/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.util;

import com.cjm721.overloaded.config.OverloadedConfig;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class PlayerInteractionUtil {
    public static boolean tryHarvestBlock(EntityPlayerMP player, World world, BlockPos pos) {
        boolean flag1;
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = iblockstate.func_177230_c();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !player.func_189808_dh()) {
            world.func_184138_a(pos, iblockstate, iblockstate, 3);
            return false;
        }
        world.func_180498_a(null, 2001, pos, Block.func_176210_f((IBlockState)iblockstate));
        if (player.field_71075_bZ.field_75098_d) {
            flag1 = PlayerInteractionUtil.removeBlock(world, pos, (EntityPlayer)player, false);
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            ItemStack itemstack1 = player.func_184614_ca();
            ItemStack itemstack2 = itemstack1.func_190926_b() ? ItemStack.field_190927_a : itemstack1.func_77946_l();
            boolean flag = iblockstate.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
            itemstack1.func_179548_a(world, iblockstate, pos, (EntityPlayer)player);
            flag1 = PlayerInteractionUtil.removeBlock(world, pos, (EntityPlayer)player, flag);
            if (flag1 && flag) {
                iblockstate.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, iblockstate, tileentity, itemstack2);
            }
        }
        if (!player.func_184812_l_() && flag1 && exp > 0) {
            iblockstate.func_177230_c().func_180637_b(world, player.func_180425_c(), exp);
        }
        return flag1;
    }

    private static boolean removeBlock(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        IBlockState iblockstate = world.func_180495_p(pos);
        boolean flag = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, player, canHarvest);
        if (flag) {
            iblockstate.func_177230_c().func_176206_d(world, pos, iblockstate);
        }
        return flag;
    }

    public static boolean placeBlock(@Nonnull ItemStack searchStack, @Nonnull EntityPlayerMP player, @Nonnull World worldIn, @Nonnull BlockPos newPosition, @Nonnull EnumFacing facing, @Nonnull IEnergyStorage energy, float hitX, float hitY, float hitZ) {
        int i;
        IBlockState iblockstate1;
        ItemBlock itemBlock = (ItemBlock)searchStack.func_77973_b();
        if (!worldIn.func_190527_a(itemBlock.func_179223_d(), newPosition, false, facing, null)) {
            return false;
        }
        BlockEvent.PlaceEvent event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)new BlockSnapshot(worldIn, newPosition, worldIn.func_180495_p(newPosition)), (EnumFacing)facing, (EnumHand)EnumHand.MAIN_HAND);
        if (event.isCanceled()) {
            return false;
        }
        long distance = Math.round(player.func_180425_c().func_185332_f(newPosition.func_177958_n(), newPosition.func_177956_o(), newPosition.func_177952_p()));
        long cost = (long)OverloadedConfig.multiToolConfig.placeBaseCost + (long)OverloadedConfig.multiToolConfig.costPerMeterAway * distance;
        if (!(player.field_71075_bZ.field_75098_d || cost <= Integer.MAX_VALUE && cost >= 0L && (long)energy.getEnergyStored() >= cost)) {
            return false;
        }
        IItemHandler inventory = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
        int foundStackSlot = PlayerInteractionUtil.findItemStackSlot(searchStack, inventory);
        if (foundStackSlot == -1) {
            return false;
        }
        ItemStack foundStack = inventory.extractItem(foundStackSlot, 1, player.field_71075_bZ.field_75098_d);
        if (itemBlock.placeBlockAt(foundStack, (EntityPlayer)player, worldIn, newPosition, facing, hitX, hitY, hitZ, iblockstate1 = itemBlock.field_150939_a.getStateForPlacement(worldIn, newPosition, facing, hitX, hitY, hitZ, i = itemBlock.func_77647_b(foundStack.func_77960_j()), (EntityLivingBase)player, EnumHand.MAIN_HAND))) {
            SoundType soundtype = worldIn.func_180495_p(newPosition).func_177230_c().getSoundType(worldIn.func_180495_p(newPosition), worldIn, newPosition, (Entity)player);
            worldIn.func_184133_a(null, newPosition, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                energy.extractEnergy((int)cost, false);
            }
            return true;
        }
        inventory.insertItem(foundStackSlot, foundStack, player.field_71075_bZ.field_75098_d);
        return false;
    }

    public static int findItemStackSlot(@Nonnull ItemStack item, @Nonnull IItemHandler inventory) {
        int size = inventory.getSlots();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (stack.func_190926_b() || !stack.func_77969_a(item)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public static RayTraceResult getBlockPlayerLookingAtClient(EntityPlayer player, float partialTicks) {
        RayTraceResult result = player.func_174822_a((double)OverloadedConfig.multiToolConfig.reach, partialTicks);
        if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
            return null;
        }
        return result;
    }
}

