/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.item;

import com.cjm721.overloaded.storage.INBTConvertible;
import com.cjm721.overloaded.storage.LongItemStack;
import com.cjm721.overloaded.storage.item.IHyperHandlerItem;
import com.cjm721.overloaded.util.IDataUpdate;
import com.cjm721.overloaded.util.ItemUtil;
import com.cjm721.overloaded.util.NumberUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class LongItemStorage
implements IItemHandler,
IHyperHandlerItem,
INBTConvertible {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private LongItemStack longItemStack;

    public LongItemStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
        this.longItemStack = new LongItemStack(ItemStack.field_190927_a, 0L);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        if (!this.longItemStack.getItemStack().func_190926_b()) {
            this.longItemStack.getItemStack().func_190920_e((int)Math.min(Integer.MAX_VALUE, this.longItemStack.getAmount()));
            return this.longItemStack.getItemStack();
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        LongItemStack result = this.give(new LongItemStack(stack, stack.func_190916_E()), !simulate);
        if (result.getAmount() == 0L) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = stack.func_77946_l();
        toReturn.func_190920_e((int)result.getAmount());
        return toReturn;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        LongItemStack result = this.take(new LongItemStack(ItemStack.field_190927_a, amount), !simulate);
        if (result.getAmount() == 0L) {
            return ItemStack.field_190927_a;
        }
        ItemStack toReturn = result.getItemStack().func_77946_l();
        toReturn.func_190920_e((int)result.getAmount());
        return toReturn;
    }

    public int getSlotLimit(int slot) {
        return Integer.MAX_VALUE;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (!this.longItemStack.getItemStack().func_190926_b()) {
            ItemStack stack = this.longItemStack.getItemStack();
            stack.func_190920_e(1);
            compound.func_74782_a("Item", (NBTBase)stack.serializeNBT());
            compound.func_74772_a("Count", this.longItemStack.getAmount());
        }
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        ItemStack storedItem;
        ItemStack itemStack = storedItem = compound.func_74764_b("Item") ? new ItemStack(compound.func_74775_l("Item")) : null;
        if (storedItem != null) {
            long storedAmount = compound.func_74764_b("Count") ? compound.func_74763_f("Count") : 0L;
            this.longItemStack = new LongItemStack(storedItem, storedAmount);
        }
    }

    @Override
    @Nonnull
    public LongItemStack status() {
        return this.longItemStack;
    }

    @Override
    @Nonnull
    public LongItemStack give(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.longItemStack.getItemStack().func_190926_b()) {
            if (doAction) {
                this.longItemStack = new LongItemStack(stack.getItemStack(), stack.getAmount());
                this.dataUpdate.dataUpdated();
            }
            return LongItemStack.EMPTY_STACK;
        }
        if (ItemUtil.itemsAreEqual(this.longItemStack.getItemStack(), stack.getItemStack())) {
            NumberUtil.AddReturn<Long> result = NumberUtil.addToMax(this.longItemStack.getAmount(), stack.getAmount());
            if (doAction) {
                this.longItemStack.setAmount((Long)result.result);
                this.dataUpdate.dataUpdated();
            }
            return new LongItemStack(stack.getItemStack(), (Long)result.overflow);
        }
        return stack;
    }

    @Override
    @Nonnull
    public LongItemStack take(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.longItemStack.getItemStack() == null) {
            return LongItemStack.EMPTY_STACK;
        }
        long result = Math.min(stack.getAmount(), this.longItemStack.getAmount());
        LongItemStack toReturn = new LongItemStack(this.longItemStack.getItemStack(), result);
        if (doAction) {
            this.longItemStack.removeAmount(result);
            if (this.longItemStack.getAmount() == 0L) {
                this.longItemStack.setItemStack(ItemStack.field_190927_a);
            }
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }
}

