/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.energy;

import com.cjm721.overloaded.storage.LongEnergyStack;
import com.cjm721.overloaded.storage.energy.IHyperHandlerEnergy;
import com.cjm721.overloaded.util.IDataUpdate;
import com.cjm721.overloaded.util.NumberUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;

public class LongEnergyStorage
implements IEnergyStorage,
IHyperHandlerEnergy,
INBTSerializable<NBTTagCompound> {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private LongEnergyStack energy = new LongEnergyStack(0L);

    public LongEnergyStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74772_a("Count", this.energy.amount);
        return compound;
    }

    public void deserializeNBT(@Nonnull NBTTagCompound compound) {
        this.energy = new LongEnergyStack(compound.func_74764_b("Count") ? compound.func_74763_f("Count") : 0L);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        LongEnergyStack result = this.give(new LongEnergyStack(maxReceive), !simulate);
        return (int)((long)maxReceive - result.amount);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        LongEnergyStack result = this.take(new LongEnergyStack(maxExtract), !simulate);
        return (int)result.amount;
    }

    public int getEnergyStored() {
        return (int)((double)this.energy.amount / 9.223372036854776E18 * 2.147483647E9);
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    @Override
    @Nonnull
    public LongEnergyStack status() {
        return this.energy;
    }

    @Override
    @Nonnull
    public LongEnergyStack give(@Nonnull LongEnergyStack stack, boolean doAction) {
        NumberUtil.AddReturn<Long> longAddReturn = NumberUtil.addToMax(this.energy.amount, stack.amount);
        if (doAction) {
            this.energy.amount = (Long)longAddReturn.result;
            this.dataUpdate.dataUpdated();
        }
        return new LongEnergyStack((Long)longAddReturn.overflow);
    }

    @Override
    @Nonnull
    public LongEnergyStack take(@Nonnull LongEnergyStack stack, boolean doAction) {
        long newStoredAmount = Math.max(this.energy.amount - stack.amount, 0L);
        LongEnergyStack result = new LongEnergyStack(Math.min(this.energy.amount, stack.amount));
        if (doAction) {
            this.energy.amount = newStoredAmount;
            this.dataUpdate.dataUpdated();
        }
        return result;
    }
}

