/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.item.functional.armor.IOverloadedPlayerDataStorage;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;

public class PlayerDataStorage
implements IOverloadedPlayerDataStorage,
INBTSerializable<NBTTagCompound> {
    private Map<String, Integer> integerMap = Maps.newHashMap();
    private Map<String, Boolean> booleanMap = Maps.newHashMap();

    @Override
    @Nonnull
    public Map<String, Integer> getIntegerMap() {
        return this.integerMap;
    }

    @Override
    @Nonnull
    public Map<String, Boolean> getBooleanMap() {
        return this.booleanMap;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        Map<String, Integer> integers = this.getIntegerMap();
        Map<String, Boolean> booleans = this.getBooleanMap();
        for (String key : integers.keySet()) {
            tagCompound.func_74768_a(key, integers.get(key).intValue());
        }
        for (String key : booleans.keySet()) {
            tagCompound.func_74757_a(key, booleans.get(key).booleanValue());
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound tagCompound) {
        Map<String, Integer> integers = this.getIntegerMap();
        Map<String, Boolean> booleans = this.getBooleanMap();
        for (String key : tagCompound.func_150296_c()) {
            integers.put(key, tagCompound.func_74762_e(key));
        }
        for (String key : booleans.keySet()) {
            booleans.put(key, tagCompound.func_74767_n(key));
        }
    }
}

