/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.item.functional.armor.IOverloadedPlayerDataStorage;
import com.cjm721.overloaded.item.functional.armor.PlayerDataStorage;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class MultiArmorCapabilityProvider
extends PlayerDataStorage
implements ICapabilityProvider {
    @CapabilityInject(value=IOverloadedPlayerDataStorage.class)
    public static Capability<IOverloadedPlayerDataStorage> PLAYER_DATA_STORAGE = null;
    private final EntityPlayer player;

    public MultiArmorCapabilityProvider(EntityPlayer player) {
        this.player = player;
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IOverloadedPlayerDataStorage.class, (Capability.IStorage)new Capability.IStorage<IOverloadedPlayerDataStorage>(){

            public NBTBase writeNBT(Capability<IOverloadedPlayerDataStorage> capability, @Nonnull IOverloadedPlayerDataStorage instance, EnumFacing side) {
                NBTTagCompound tagCompound = new NBTTagCompound();
                Map<String, Integer> integers = instance.getIntegerMap();
                Map<String, Boolean> booleans = instance.getBooleanMap();
                for (String key : integers.keySet()) {
                    tagCompound.func_74768_a(key, integers.get(key).intValue());
                }
                for (String key : booleans.keySet()) {
                    tagCompound.func_74757_a(key, booleans.get(key).booleanValue());
                }
                return tagCompound;
            }

            public void readNBT(Capability<IOverloadedPlayerDataStorage> capability, @Nonnull IOverloadedPlayerDataStorage instance, EnumFacing side, NBTBase nbt) {
                if (!(nbt instanceof NBTTagCompound)) {
                    return;
                }
                NBTTagCompound tagCompound = (NBTTagCompound)nbt;
                Map<String, Integer> integers = instance.getIntegerMap();
                Map<String, Boolean> booleans = instance.getBooleanMap();
                for (String key : tagCompound.func_150296_c()) {
                    integers.put(key, tagCompound.func_74762_e(key));
                }
                for (String key : booleans.keySet()) {
                    booleans.put(key, tagCompound.func_74767_n(key));
                }
            }
        }, PlayerDataStorage.class);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing enumFacing) {
        return capability == PLAYER_DATA_STORAGE;
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing enumFacing) {
        if (capability == PLAYER_DATA_STORAGE) {
            return (T)PLAYER_DATA_STORAGE.cast((Object)this);
        }
        return null;
    }
}

