/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.functional.armor.IMultiArmor;
import com.cjm721.overloaded.item.functional.armor.IOverloadedPlayerDataStorage;
import com.cjm721.overloaded.item.functional.armor.MultiArmorCapabilityProvider;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.FoodStats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ArmorEventHandler {
    private static final String set = "set";

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            event.addCapability(new ResourceLocation("overloaded", "playerData"), (ICapabilityProvider)new MultiArmorCapabilityProvider((EntityPlayer)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onLivingUpdateEvent(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        IOverloadedPlayerDataStorage dataStorage = this.getDataStorage(player);
        if (this.isMultiArmorSetEquipped(player)) {
            this.tryEnableFlight(player, dataStorage, event.side);
            this.tryFeedPlayer(player, event.side);
            this.tryHealPlayer(player, event.side);
            this.tryRemoveHarmful(player, event.side);
            this.tryExtinguish(player, event.side);
        } else {
            this.disableFlight(player, dataStorage, event.side);
        }
    }

    private void tryExtinguish(EntityPlayer player, Side side) {
        if (player.func_70027_ad() && this.extractEnergy(player, OverloadedConfig.multiArmorConfig.extinguishCost, side.isClient())) {
            player.func_70066_B();
        }
    }

    private void tryHealPlayer(EntityPlayer player, Side side) {
        float currentHealth = player.func_110143_aJ();
        float maxHealth = player.func_110138_aP();
        int toHeal = (int)Math.ceil(maxHealth - currentHealth);
        if (toHeal > 0 && this.extractEnergy(player, OverloadedConfig.multiArmorConfig.costPerHealth * toHeal, side.isClient())) {
            player.func_70606_j(maxHealth);
        }
    }

    private void tryRemoveHarmful(EntityPlayer player, Side side) {
        Iterator potionEffectIterator = player.func_70651_bq().iterator();
        while (potionEffectIterator.hasNext()) {
            PotionEffect effect = (PotionEffect)potionEffectIterator.next();
            Potion potion = effect.func_188419_a();
            if (!potion.func_76398_f() || !this.extractEnergy(player, OverloadedConfig.multiArmorConfig.removeEffect, side.isClient())) continue;
            potionEffectIterator.remove();
        }
    }

    private void tryFeedPlayer(EntityPlayer player, Side side) {
        FoodStats foodStats = player.func_71024_bL();
        int foodLevel = foodStats.func_75116_a();
        int toFeed = OverloadedConfig.multiArmorConfig.maxFoodLevel - foodLevel;
        if (toFeed > 0 && this.extractEnergy(player, OverloadedConfig.multiArmorConfig.costPerFood * toFeed, side.isClient())) {
            foodStats.func_75114_a(OverloadedConfig.multiArmorConfig.maxFoodLevel);
        }
    }

    private void tryEnableFlight(EntityPlayer player, IOverloadedPlayerDataStorage dataStorage, Side side) {
        Map<String, Boolean> booleans = dataStorage.getBooleanMap();
        player.field_71075_bZ.field_75101_c = true;
        if (side.isClient()) {
            player.field_71075_bZ.func_75092_a(0.1f);
        }
        booleans.put(set, true);
        if (player.field_71075_bZ.field_75100_b && !this.extractEnergy(player, OverloadedConfig.multiArmorConfig.energyPerTickFlying, side.isClient())) {
            this.disableFlight(player, dataStorage, side);
        }
    }

    private void disableFlight(EntityPlayer player, IOverloadedPlayerDataStorage dataStorage, Side side) {
        Map<String, Boolean> booleans = dataStorage.getBooleanMap();
        if (booleans.containsKey(set) && booleans.get(set).booleanValue()) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            if (side.isClient()) {
                player.field_71075_bZ.func_75092_a(0.05f);
            }
            booleans.put(set, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingAttackedEvent(LivingAttackEvent event) {
        Entity entity = event.getEntity();
        if (entity == null || !(entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        boolean setEquipped = this.isMultiArmorSetEquipped(player);
        if (setEquipped) {
            DamageSource damageSource = event.getSource();
            int energyCost = OverloadedConfig.multiArmorConfig.baseCost;
            float damageAmount = event.getAmount() * OverloadedConfig.multiArmorConfig.damageMultiplier;
            if (damageSource.func_151517_h()) {
                damageAmount *= OverloadedConfig.multiArmorConfig.absoluteDamageMultiplier;
            }
            if (damageSource.func_76363_c()) {
                damageAmount *= OverloadedConfig.multiArmorConfig.unblockableMultiplier;
            }
            if (damageAmount > 2.1474836E9f) {
                return;
            }
            if ((energyCost = (int)((float)energyCost + damageAmount)) < 0) {
                return;
            }
            if (this.extractEnergy(player, energyCost, false)) {
                event.setCanceled(true);
            }
        }
    }

    private boolean extractEnergy(EntityPlayer player, int energyCost, boolean simulated) {
        IEnergyStorage energyStorage;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage != null) {
                energyCost -= energyStorage.extractEnergy(energyCost / 4, simulated);
            }
            if (energyCost > 0) continue;
            return true;
        }
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            energyStorage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            if (energyStorage != null) {
                energyCost -= energyStorage.extractEnergy(energyCost, simulated);
            }
            if (energyCost != 0) continue;
            return true;
        }
        return false;
    }

    private IOverloadedPlayerDataStorage getDataStorage(EntityPlayer player) {
        return (IOverloadedPlayerDataStorage)player.getCapability(MultiArmorCapabilityProvider.PLAYER_DATA_STORAGE, null);
    }

    protected boolean isMultiArmorSetEquipped(EntityPlayer player) {
        boolean setEquipped = true;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (stack.func_77973_b() instanceof IMultiArmor) continue;
            setEquipped = false;
        }
        return setEquipped;
    }
}

