/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional.armor;

import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.item.functional.armor.IMultiArmor;
import com.cjm721.overloaded.util.IModRegistrable;
import com.cjm721.overloaded.util.itemwrapper.IntEnergyWrapper;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.text.NumberFormat;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class AbstractMultiArmor
extends ItemArmor
implements IModRegistrable,
IMultiArmor {
    private static final UUID[] ARMOR_MODIFIERS = new UUID[]{UUID.fromString("845DB27C-C624-495F-8C9F-6020A9A58B6B"), UUID.fromString("D8499B04-0E66-4726-AB29-64469D734E0D"), UUID.fromString("9F3D476D-C118-4544-8365-64846904B48E"), UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150")};
    public static ItemArmor.ArmorMaterial pureMatter = EnumHelper.addArmorMaterial((String)"pureMatter", (String)"overloaded:na", (int)100, (int[])new int[]{6, 12, 16, 6}, (int)50, (SoundEvent)SoundEvents.field_187722_q, (float)4.0f);

    public AbstractMultiArmor(int render_index, EntityEquipmentSlot equipmentSlot) {
        super(pureMatter, render_index, equipmentSlot);
        this.func_77656_e(-1);
        this.func_77637_a(OverloadedCreativeTabs.TECH);
        ModItems.addToSecondaryInit(this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        IEnergyStorage handler = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        tooltip.add("Energy Stored: " + NumberFormat.getInstance().format(handler.getEnergyStored()));
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public final boolean func_77645_m() {
        return false;
    }

    @Nullable
    public final ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new IntEnergyWrapper(stack);
    }

    public boolean showDurabilityBar(ItemStack itemStack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            return 1.0 - (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored();
        }
        return 1.0;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nonnull
    @Deprecated
    public Multimap<String, AttributeModifier> func_111205_h(@Nonnull EntityEquipmentSlot equipmentSlot) {
        return HashMultimap.create();
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        if (this.hasPower(stack)) {
            Multimap multimap = super.func_111205_h(equipmentSlot);
            if (equipmentSlot == this.field_77881_a) {
                multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor modifier", (double)this.field_77879_b, 0));
                multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Armor toughness", (double)this.field_189415_e, 0));
                multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)new AttributeModifier(ARMOR_MODIFIERS[equipmentSlot.func_188454_b()], "Max Health", (double)(this.field_77879_b / 2), 0));
            }
            return multimap;
        }
        return HashMultimap.create();
    }

    protected boolean hasPower(ItemStack stack) {
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        return energy.getEnergyStored() > 0;
    }
}

