/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.block.ModBlocks;
import com.cjm721.overloaded.client.render.dynamic.general.ResizeableTextureGenerator;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.ModItem;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.network.packets.MultiToolLeftClickMessage;
import com.cjm721.overloaded.network.packets.MultiToolRightClickMessage;
import com.cjm721.overloaded.util.AssistMode;
import com.cjm721.overloaded.util.BlockResult;
import com.cjm721.overloaded.util.PlayerInteractionUtil;
import com.cjm721.overloaded.util.RenderUtil;
import com.cjm721.overloaded.util.itemwrapper.IntEnergyWrapper;
import com.google.common.collect.ImmutableSet;
import java.text.NumberFormat;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMultiTool
extends ModItem {
    private static final Set<String> toolClasses = ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe");

    public ItemMultiTool() {
        this.func_77625_d(1);
        this.setRegistryName("multi_tool");
        this.func_77655_b("multi_tool");
        this.func_77637_a(OverloadedCreativeTabs.TECH);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment != null && enchantment.field_77351_y == EnumEnchantmentType.DIGGER;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 15;
    }

    public boolean func_77616_k(@Nonnull ItemStack stack) {
        return this.getItemStackLimit(stack) == 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "multi_tool"), null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
        ResizeableTextureGenerator.addToTextureQueue(new ResizeableTextureGenerator.ResizableTexture(new ResourceLocation("overloaded", "textures/items/ntool.png"), new ResourceLocation("overloaded", "textures/dynamic/items/ntool.png"), OverloadedConfig.textureResolutions.blockResolution));
    }

    @Override
    public void registerRecipe() {
        if (OverloadedConfig.recipeEnabledConfig.multiTool) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"NI ", "IES", " SB", Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('E'), ModItems.energyCore, Character.valueOf('B'), Blocks.field_150339_S, Character.valueOf('S'), ModBlocks.netherStarBlock});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        IEnergyStorage handler = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        tooltip.add("Energy Stored: " + NumberFormat.getInstance().format(handler.getEnergyStored()));
        tooltip.add("Assist Mode: " + this.getAssistMode().getName());
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
            int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack);
            float breakCost = this.getBreakCost(worldIn.func_180495_p(pos).func_185887_b(worldIn, pos), efficiency, unbreaking, entityLiving == null ? 10.0 : this.getDistance(entityLiving, pos));
            storage.extractEnergy((int)Math.min(2.1474836E9f, breakCost), false);
        }
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    private double getDistance(@Nonnull EntityLivingBase entityLiving, @Nonnull BlockPos pos) {
        return entityLiving.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        return player == null || super.canDestroyBlockInCreative(world, pos, stack, player) && !player.func_70093_af();
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return 0.0f;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public ActionResult<ItemStack> func_77659_a(@Nonnull World worldIn, @Nonnull EntityPlayer player, @Nonnull EnumHand hand) {
        RayTraceResult result;
        if (worldIn.field_72995_K && (result = PlayerInteractionUtil.getBlockPlayerLookingAtClient(player, Minecraft.func_71410_x().func_184121_ak())) != null) {
            Overloaded.proxy.networkWrapper.sendToServer((IMessage)new MultiToolRightClickMessage(result.func_178782_a(), result.field_178784_b, (float)result.field_72307_f.field_72450_a - (float)result.func_178782_a().func_177958_n(), (float)result.field_72307_f.field_72448_b - (float)result.func_178782_a().func_177956_o(), (float)result.field_72307_f.field_72449_c - (float)result.func_178782_a().func_177952_p()));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private float getBreakCost(float hardness, int efficiency, int unbreaking, double distance) {
        float floatBreakCost = (float)((double)(hardness * (float)OverloadedConfig.multiToolConfig.breakCostMultiplier / (float)(efficiency + 1) + (float)(OverloadedConfig.multiToolConfig.breakBaseCost / (unbreaking + 1))) + distance);
        return floatBreakCost;
    }

    @Nonnull
    private BlockResult breakAndUseEnergy(@Nonnull World worldIn, @Nonnull BlockPos blockPos, @Nonnull IEnergyStorage energy, @Nonnull EntityPlayerMP player, int efficiency, int unbreaking) {
        IBlockState state = worldIn.func_180495_p(blockPos);
        if (!player.field_71075_bZ.field_75098_d) {
            float hardness = state.func_185887_b(worldIn, blockPos);
            if (hardness < 0.0f) {
                return BlockResult.FAIL_UNBREAKABLE;
            }
            float floatBreakCost = this.getBreakCost(hardness, efficiency, unbreaking, this.getDistance((EntityLivingBase)player, blockPos));
            if (Float.isInfinite(floatBreakCost) || Float.isNaN(floatBreakCost)) {
                return BlockResult.FAIL_ENERGY;
            }
            int breakCost = Math.round(floatBreakCost);
            if (breakCost < 0 || energy.getEnergyStored() < breakCost) {
                return BlockResult.FAIL_ENERGY;
            }
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(worldIn, blockPos, state, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return BlockResult.FAIL_REMOVE;
        }
        boolean result = PlayerInteractionUtil.tryHarvestBlock(player, worldIn, blockPos);
        return result ? BlockResult.SUCCESS : BlockResult.FAIL_REMOVE;
    }

    public void drawParticleStreamTo(@Nonnull EntityPlayer source, @Nonnull Vec3d endingLocation, @Nonnull EnumParticleTypes type) {
        double xOffset = 0.0;
        double yOffset = -0.25;
        double zOffset = 0.0;
        Vec3d startingLocation = source.func_174824_e(1.0f).func_72441_c(xOffset, yOffset, zOffset);
        startingLocation = startingLocation.func_178787_e(source.func_70040_Z().func_178785_b(-1.5707964f).func_186678_a(0.5));
        Vec3d direction = endingLocation.func_178788_d(startingLocation).func_72432_b();
        startingLocation = startingLocation.func_178787_e(direction);
        World world = source.func_130014_f_();
        double distanceToEnd = endingLocation.func_72438_d(startingLocation);
        while (distanceToEnd > 0.3 && distanceToEnd < (double)(OverloadedConfig.multiToolConfig.reach * 2)) {
            world.func_175688_a(type, startingLocation.field_72450_a, startingLocation.field_72448_b, startingLocation.field_72449_c, 0.0, 0.0, 0.0, new int[0]);
            startingLocation = startingLocation.func_178787_e(direction.func_186678_a(0.25));
            distanceToEnd = endingLocation.func_72438_d(startingLocation);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void leftClickBlock(@Nonnull PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide() == Side.SERVER || event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b().equals(this)) {
            this.leftClickOnBlockClient(event.getPos(), event.getHitVec());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void leftClickEmpty(@Nonnull PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayer entityLiving;
        RayTraceResult result;
        if (event.getSide() == Side.SERVER || event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b().equals(this) && (result = PlayerInteractionUtil.getBlockPlayerLookingAtClient(entityLiving = event.getEntityPlayer(), Minecraft.func_71410_x().func_184121_ak())) != null) {
            this.leftClickOnBlockClient(result.func_178782_a(), result.field_72307_f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getDwheel() != 0 && player != null && player.func_70093_af()) {
            ItemStack stack = player.func_184614_ca();
            if (player.func_70093_af() && !stack.func_190926_b() && stack.func_77973_b() == this) {
                this.changeHelpMode(event.getDwheel());
                player.func_146105_b((ITextComponent)new TextComponentString("Assist Mode: " + this.getAssistMode().getName()), true);
                event.setCanceled(true);
            }
        }
    }

    private void changeHelpMode(int dwheel) {
        AssistMode[] values = AssistMode.values();
        int mode = (OverloadedConfig.multiToolConfig.assistMode + Integer.signum(dwheel)) % values.length;
        if (mode < 0) {
            mode += values.length;
        }
        OverloadedConfig.multiToolConfig.assistMode = mode;
        ConfigManager.sync((String)"overloaded", (Config.Type)Config.Type.INSTANCE);
    }

    @Nonnull
    private AssistMode getAssistMode() {
        AssistMode[] values = AssistMode.values();
        int mode = OverloadedConfig.multiToolConfig.assistMode;
        for (AssistMode assistMode : values) {
            if (assistMode.getMode() != mode) continue;
            return assistMode;
        }
        this.changeHelpMode(0);
        return AssistMode.NONE;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void teleportDrops(@Nonnull BlockEvent.HarvestDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || event.getHarvester().func_184614_ca().func_77973_b() != this) {
            return;
        }
        World world = event.getWorld();
        float chance = event.getDropChance();
        for (ItemStack stack : event.getDrops()) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            EntityItem toSpawn = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            world.func_72838_d((Entity)toSpawn);
        }
        event.getDrops().clear();
    }

    @SideOnly(value=Side.CLIENT)
    private void leftClickOnBlockClient(BlockPos pos, Vec3d hitVec) {
        MultiToolLeftClickMessage message = new MultiToolLeftClickMessage(pos);
        Overloaded.proxy.networkWrapper.sendToServer((IMessage)message);
    }

    public void leftClickOnBlockServer(@Nonnull World world, @Nonnull EntityPlayerMP player, @Nonnull BlockPos pos) {
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack.func_77973_b() != this || world.func_175623_d(pos)) {
            return;
        }
        player.func_184598_c(EnumHand.MAIN_HAND);
        if (player.func_70093_af()) {
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            IBlockState state = world.func_180495_p(pos);
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            ItemStack stackToPlace = new ItemStack(item, 1, state.func_177230_c().func_180651_a(state));
            NBTTagCompound blockTag = new NBTTagCompound();
            stackToPlace.func_77955_b(blockTag);
            tag.func_74782_a("Item", (NBTBase)blockTag);
            itemStack.func_77982_d(tag);
            ITextComponent component = stackToPlace.func_151000_E();
            player.func_146105_b(new TextComponentString("Bound tool to ").func_150257_a(component), true);
        } else {
            IEnergyStorage energy = (IEnergyStorage)itemStack.getCapability(CapabilityEnergy.ENERGY, null);
            int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)itemStack);
            int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)itemStack);
            switch (this.breakAndUseEnergy(world, pos, energy, player, efficiency, unbreaking)) {
                case FAIL_REMOVE: {
                    player.func_146105_b((ITextComponent)new TextComponentString("Unable to break block, reason unknown"), true);
                    break;
                }
                case FAIL_ENERGY: {
                    player.func_146105_b((ITextComponent)new TextComponentString("Unable to break block, not enough energy"), true);
                    break;
                }
                case FAIL_UNBREAKABLE: {
                    player.func_146105_b((ITextComponent)new TextComponentString("Block is unbreakable"), true);
                    break;
                }
            }
        }
    }

    public void rightClickWithItem(@Nonnull World worldIn, @Nonnull EntityPlayerMP player, @Nonnull BlockPos pos, @Nonnull EnumFacing sideHit, float hitX, float hitY, float hitZ) {
        ItemStack multiTool = player.func_184614_ca();
        if (multiTool.func_77973_b() != this) {
            return;
        }
        ItemStack blockStack = this.getSelectedBlockItemStack(multiTool);
        if (blockStack.func_190926_b()) {
            player.func_146105_b((ITextComponent)new TextComponentString("No block type selected to place."), true);
            return;
        }
        if (!(blockStack.func_77973_b() instanceof ItemBlock)) {
            player.func_146105_b((ITextComponent)new TextComponentString("No valid block type selected to place."), true);
            return;
        }
        IEnergyStorage energy = (IEnergyStorage)multiTool.getCapability(CapabilityEnergy.ENERGY, null);
        Vec3i sideVector = sideHit.func_176730_m();
        BlockPos.MutableBlockPos newPosition = new BlockPos.MutableBlockPos(pos.func_177971_a(sideVector));
        if (!PlayerInteractionUtil.placeBlock(blockStack, player, worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) {
            player.func_146105_b((ITextComponent)new TextComponentString("Unable to place blocks"), true);
            return;
        }
        if (player.func_70093_af()) {
            BlockPos playerPos = player.func_180425_c();
            block0 : switch (sideHit) {
                case UP: {
                    while (newPosition.func_177956_o() < playerPos.func_177956_o()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) continue;
                        break block0;
                    }
                    break;
                }
                case DOWN: {
                    while (newPosition.func_177956_o() > playerPos.func_177956_o()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) continue;
                        break block0;
                    }
                    break;
                }
                case NORTH: {
                    while (newPosition.func_177952_p() > playerPos.func_177952_p()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) continue;
                        break block0;
                    }
                    break;
                }
                case SOUTH: {
                    while (newPosition.func_177952_p() < playerPos.func_177952_p()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) continue;
                        break block0;
                    }
                    break;
                }
                case EAST: {
                    while (newPosition.func_177958_n() < playerPos.func_177958_n()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) continue;
                        break block0;
                    }
                    break;
                }
                case WEST: {
                    while (newPosition.func_177958_n() > playerPos.func_177958_n()) {
                        newPosition.func_189536_c(sideHit);
                        if (PlayerInteractionUtil.placeBlock(blockStack, player, worldIn, (BlockPos)newPosition, sideHit, energy, hitX, hitY, hitZ)) continue;
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    private ItemStack getSelectedBlockItemStack(ItemStack multiTool) {
        NBTTagCompound tagCompound = multiTool.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Item")) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound itemTag = tagCompound.func_74775_l("Item");
        return new ItemStack(itemTag);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new IntEnergyWrapper(stack);
    }

    @Nonnull
    public Set<String> getToolClasses(ItemStack stack) {
        return toolClasses;
    }

    public boolean showDurabilityBar(ItemStack p_showDurabilityBar_1_) {
        return true;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return true;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184614_ca().func_77973_b() != this) {
            return;
        }
        ItemStack stack = this.getSelectedBlockItemStack(player.func_184614_ca());
        if (stack.func_190926_b()) {
            return;
        }
        RayTraceResult result = PlayerInteractionUtil.getBlockPlayerLookingAtClient((EntityPlayer)player, event.getPartialTicks());
        if (result == null) {
            return;
        }
        IBlockState state = stack.func_77973_b() instanceof ItemBlock ? ((ItemBlock)stack.func_77973_b()).field_150939_a.func_176223_P() : Blocks.field_150347_e.func_176223_P();
        switch (this.getAssistMode()) {
            case PLACE_PREVIEW: {
                this.renderBlockPreview(event, (EntityPlayer)player, stack, result, state);
                break;
            }
            case REMOVE_PREVIEW: {
                this.renderRemovePreview(event, (EntityPlayer)player, result);
                break;
            }
            case BOTH_PREVIEW: {
                this.renderBlockPreview(event, (EntityPlayer)player, stack, result, state);
                this.renderRemovePreview(event, (EntityPlayer)player, result);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderRemovePreview(RenderWorldLastEvent event, EntityPlayer player, RayTraceResult result) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("overloaded", "block/remove_preview"));
            IBakedModel bakeModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString()));
            BlockPos toRenderAt = result.func_178782_a();
            float partialTicks = event.getPartialTicks();
            double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
            double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
            double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)toRenderAt.func_177958_n() - x), (double)((double)toRenderAt.func_177956_o() - y), (double)((double)toRenderAt.func_177952_p() - z));
            RenderUtil.renderGhostModel(bakeModel, Blocks.field_150347_e.func_176223_P(), player.func_130014_f_(), toRenderAt);
            GlStateManager.func_179121_F();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void renderBlockPreview(RenderWorldLastEvent event, EntityPlayer player, ItemStack stack, RayTraceResult result, IBlockState state) {
        BlockPos toRenderAt = result.func_178782_a().func_177971_a(result.field_178784_b.func_176730_m());
        float partialTicks = event.getPartialTicks();
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)((double)toRenderAt.func_177958_n() - x), (double)((double)toRenderAt.func_177956_o() - y), (double)((double)toRenderAt.func_177952_p() - z));
        RenderUtil.renderGhostModel(Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack), state, player.func_130014_f_(), toRenderAt);
        GlStateManager.func_179121_F();
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            return 1.0 - (double)storage.getEnergyStored() / (double)storage.getMaxEnergyStored();
        }
        return 1.0;
    }

    public boolean func_77651_p() {
        return true;
    }
}

