/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.dynamic.general;

import com.cjm721.overloaded.client.render.dynamic.ImageUtil;
import com.cjm721.overloaded.client.resource.BlockResourcePack;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ResizeableTextureGenerator {
    private static List<ResizableTexture> toCreateTextures = new ArrayList<ResizableTexture>();

    public static void addToTextureQueue(ResizableTexture location) {
        toCreateTextures.add(location);
    }

    @SubscribeEvent
    public void texturePre(@Nonnull TextureStitchEvent.Pre event) {
        for (ResizableTexture resizableTexture : toCreateTextures) {
            BufferedImage image = null;
            try {
                image = TextureUtil.func_177053_a((InputStream)ImageUtil.getTextureInputStream(resizableTexture.originalTexture));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (image == null) continue;
            image = ImageUtil.scaleToWidth(image, resizableTexture.resizeToWidth);
            BlockResourcePack.INSTANCE.addImage(resizableTexture.generatedName, image);
            event.getMap().func_174942_a(this.cleanForSprite(resizableTexture.generatedName));
        }
    }

    @Nonnull
    private ResourceLocation cleanForSprite(@Nonnull ResourceLocation location) {
        String path = location.func_110623_a();
        if (path.startsWith("textures/")) {
            return new ResourceLocation(location.func_110624_b(), path.substring(9).replace(".png", ""));
        }
        return location;
    }

    public static class ResizableTexture {
        public final ResourceLocation originalTexture;
        public final ResourceLocation generatedName;
        public final int resizeToWidth;

        public ResizableTexture(ResourceLocation originalTexture, ResourceLocation generatedName, int resizeToWidth) {
            this.originalTexture = originalTexture;
            this.generatedName = generatedName;
            this.resizeToWidth = resizeToWidth;
        }
    }
}

