/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.tile.hyperTransfer.base;

import com.cjm721.overloaded.block.tile.hyperTransfer.base.AbstractTileHyperReceiver;
import com.cjm721.overloaded.storage.IHyperHandler;
import com.cjm721.overloaded.storage.IHyperType;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;

public abstract class AbstractTileHyperSender<T extends IHyperType, H extends IHyperHandler<T>>
extends TileEntity
implements ITickable {
    private int delayTicks;
    private BlockPos partnerBlockPos;
    private int partnerWorldID;
    private final Capability<H> capability;

    public AbstractTileHyperSender(Capability<H> capability) {
        this.capability = capability;
    }

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this.partnerBlockPos != null) {
            compound.func_74768_a("X", this.partnerBlockPos.func_177958_n());
            compound.func_74768_a("Y", this.partnerBlockPos.func_177956_o());
            compound.func_74768_a("Z", this.partnerBlockPos.func_177952_p());
            compound.func_74768_a("WORLD", this.partnerWorldID);
        }
        return compound;
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("X")) {
            int x = compound.func_74762_e("X");
            int y = compound.func_74762_e("Y");
            int z = compound.func_74762_e("Z");
            this.partnerBlockPos = new BlockPos(x, y, z);
            this.partnerWorldID = compound.func_74762_e("WORLD");
        }
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.delayTicks % 20 == 0) {
            if (this.partnerBlockPos == null) {
                return;
            }
            AbstractTileHyperReceiver<T, H> partner = this.findPartner();
            if (partner != null) {
                this.send(partner);
            }
        }
        ++this.delayTicks;
    }

    @Nullable
    private AbstractTileHyperReceiver<T, H> findPartner() {
        WorldServer world = DimensionManager.getWorld((int)this.partnerWorldID);
        if (world != null && world.func_175667_e(this.partnerBlockPos)) {
            TileEntity partnerTE = world.func_175625_s(this.partnerBlockPos);
            if (partnerTE == null || !this.isCorrectPartnerType(partnerTE)) {
                this.partnerBlockPos = null;
                return null;
            }
            return (AbstractTileHyperReceiver)partnerTE;
        }
        return null;
    }

    protected void send(@Nonnull AbstractTileHyperReceiver<T, H> partner) {
        for (EnumFacing side : EnumFacing.values()) {
            TileEntity te = this.func_145831_w().func_175625_s(this.func_174877_v().func_177971_a(side.func_176730_m()));
            if (te == null || !te.hasCapability(this.capability, side.func_176734_d())) continue;
            this.send(partner, te, side);
        }
    }

    protected void send(@Nonnull AbstractTileHyperReceiver<T, H> partner, @Nonnull TileEntity te, @Nonnull EnumFacing side) {
        T tookOut;
        T leftOvers;
        IHyperHandler handler = (IHyperHandler)te.getCapability(this.capability, side.func_176734_d());
        T itemStack = handler.take(this.generate(Long.MAX_VALUE), false);
        if (itemStack.getAmount() > 0L && (leftOvers = partner.receive(itemStack)).getAmount() != itemStack.getAmount() && (tookOut = handler.take(this.generate(itemStack.getAmount() - leftOvers.getAmount()), true)).getAmount() != itemStack.getAmount() - leftOvers.getAmount()) {
            throw new RuntimeException("IHyperHandler Take was not consistent");
        }
    }

    @Nonnull
    protected abstract T generate(long var1);

    protected abstract boolean isCorrectPartnerType(TileEntity var1);

    public void setPartnerInfo(int partnerWorldId, BlockPos partnerPos) {
        this.partnerWorldID = partnerWorldId;
        this.partnerBlockPos = partnerPos;
    }

    @Nonnull
    public String getRightClickMessage() {
        if (this.partnerBlockPos != null) {
            return String.format("Bound to Receiver at %d:%d,%d,%d", this.partnerWorldID, this.partnerBlockPos.func_177958_n(), this.partnerBlockPos.func_177956_o(), this.partnerBlockPos.func_177952_p());
        }
        return "Not bound to anything";
    }
}

