/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.tile;

import com.cjm721.overloaded.storage.energy.LongEnergyStorage;
import com.cjm721.overloaded.storage.fluid.LongFluidStorage;
import com.cjm721.overloaded.util.CapabilityHyperEnergy;
import com.cjm721.overloaded.util.CapabilityHyperFluid;
import com.cjm721.overloaded.util.IDataUpdate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileMatterPurifier
extends TileEntity
implements ITickable,
IDataUpdate {
    private LongFluidStorage fluidStorage = new LongFluidStorage(this);
    private LongEnergyStorage energyStorage = new LongEnergyStorage(this);
    private ItemStack input = ItemStack.field_190927_a;

    public void func_73660_a() {
        if (!this.input.func_190926_b()) {
            // empty if block
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fluidStorage.readFromNBT(compound.func_74775_l("Fluid"));
        this.energyStorage.deserializeNBT(compound.func_74775_l("Energy"));
        this.input = new ItemStack(compound.func_74775_l("Item"));
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound fluid = new NBTTagCompound();
        NBTTagCompound energy = this.energyStorage.serializeNBT();
        this.fluidStorage.writeToNBT(fluid);
        compound.func_74782_a("Fluid", (NBTBase)fluid);
        compound.func_74782_a("Energy", (NBTBase)energy);
        compound.func_74782_a("Item", (NBTBase)this.input.func_77978_p());
        return super.func_189515_b(compound);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityHyperFluid.HYPER_FLUID_HANDLER || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidStorage;
        }
        if (capability == CapabilityHyperEnergy.HYPER_ENERGY_HANDLER || capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityHyperFluid.HYPER_FLUID_HANDLER || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityHyperEnergy.HYPER_ENERGY_HANDLER || capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Override
    public void dataUpdated() {
        this.func_70296_d();
    }
}

