/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.tile;

import com.mojang.authlib.GameProfile;
import java.lang.ref.WeakReference;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileItemManipulator
extends TileEntity
implements ITickable {
    private static GameProfile FAKEPLAYER = new GameProfile(UUID.fromString("85824917-23F6-4B28-8B12-FAED16A3F66B"), "[Overloaded:Item_Manipulator]");
    private EnergyStorage energyStorage;
    private ItemStackHandler itemStack = new ItemStackHandler();
    private WeakReference<FakePlayer> player;
    private EnumFacing facing;

    public TileItemManipulator() {
        this.energyStorage = new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, 0);
    }

    public void func_145839_a(NBTTagCompound compound) {
        if (compound.func_74764_b("Item")) {
            this.itemStack.deserializeNBT(compound.func_74775_l("Item"));
        }
        if (compound.func_74764_b("Energy")) {
            this.energyStorage = new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, 0, compound.func_74762_e("Energy"));
        }
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74782_a("Item", (NBTBase)this.itemStack.serializeNBT());
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(compound);
    }

    public void func_73660_a() {
        ItemStack currentItem = this.itemStack.getStackInSlot(0);
        if (currentItem.func_190926_b()) {
            return;
        }
        FakePlayer player = this.getPlayer();
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos(this.func_174877_v());
        int i = 0;
        while ((double)i < player.field_71134_c.getBlockReachDistance()) {
            if (!this.func_145831_w().func_175623_d((BlockPos)blockPos.func_189536_c(this.facing))) {
                EnumActionResult result = currentItem.func_77973_b().func_180614_a((EntityPlayer)player, this.func_145831_w(), (BlockPos)blockPos, EnumHand.MAIN_HAND, this.facing.func_176734_d(), 0.5f, 0.5f, 0.5f);
                break;
            }
            ++i;
        }
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY || capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemStack;
        }
        return (T)super.getCapability(capability, facing);
    }

    public TileItemManipulator setFacing(EnumFacing facing) {
        this.facing = facing;
        return this;
    }

    private FakePlayer getPlayer() {
        if (this.player == null || this.player.get() == null) {
            FakePlayer fakePlayer = FakePlayerFactory.get((WorldServer)((WorldServer)this.func_145831_w()), (GameProfile)FAKEPLAYER);
            this.player = new WeakReference<FakePlayer>(fakePlayer);
            fakePlayer.func_70012_b((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), 0.0f, 0.0f);
            fakePlayer.field_71071_by.func_174888_l();
        }
        return (FakePlayer)this.player.get();
    }

    public void breakBlock() {
        ItemStack storedItem = this.itemStack.getStackInSlot(0);
        if (!storedItem.func_190926_b()) {
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), storedItem));
        }
    }
}

