/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.compressed;

import com.cjm721.overloaded.block.compressed.BlockCompressed;
import com.cjm721.overloaded.config.OverloadedConfig;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.crash.CrashReport;
import net.minecraft.init.Blocks;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.CustomModLoadingErrorDisplayException;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CompressedBlockHandler {
    public static Map<Integer, Block> CreateCompressedBlocks(@Nonnull Block toCompress, int depth, boolean recipeEnabled) {
        HashMap<Integer, Block> compressedBlocks = new HashMap<Integer, Block>();
        Material material = toCompress.func_176223_P().func_185904_a();
        String registryName = toCompress.getRegistryName().func_110623_a();
        String unlocalizedName = toCompress.func_149739_a();
        float baseHardness = toCompress.func_176223_P().func_185887_b(null, null);
        String harvestTool = toCompress.getHarvestTool(toCompress.func_176223_P());
        int harvestLevel = toCompress.getHarvestLevel(toCompress.func_176223_P());
        compressedBlocks.put(0, toCompress);
        Block previousLevel = toCompress;
        float currentHardness = baseHardness;
        for (int i = 1; i <= depth; ++i) {
            String compRegistryName = String.format("compressed%s%d", registryName, i);
            String compUnlocalizedName = String.format("%dxCompressed:%s", i, unlocalizedName);
            if ((currentHardness *= 9.0f) < 0.0f) {
                currentHardness = Float.MAX_VALUE;
            }
            BlockCompressed block = new BlockCompressed(toCompress, previousLevel, i, material, compRegistryName, compUnlocalizedName, currentHardness, harvestTool, harvestLevel, recipeEnabled);
            previousLevel = block;
            compressedBlocks.put(i, block);
        }
        return compressedBlocks;
    }

    public static void initFromConfig() {
        IForgeRegistry registry = GameRegistry.findRegistry(Block.class);
        for (String setting : OverloadedConfig.compressedConfig.compressedBlocks) {
            if (setting.isEmpty()) continue;
            String[] split = setting.split(":");
            if (split.length < 4) {
                if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                    CompressedBlockHandler.throwClientSideError(setting);
                } else {
                    throw new ReportedException(CrashReport.func_85055_a((Throwable)new RuntimeException("Compressed Blocks Config is invalid. Looking at compressed block: " + setting), (String)"Invalid Compressed Block Config"));
                }
            }
            String domain = split[0];
            String blockName = split[1];
            int depth = Integer.parseInt(split[2]);
            boolean recipeEnabled = Boolean.parseBoolean(split[3]);
            Block block = (Block)registry.getValue(new ResourceLocation(domain, blockName));
            if (block == Blocks.field_150350_a) continue;
            CompressedBlockHandler.CreateCompressedBlocks(block, depth, recipeEnabled);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void throwClientSideError(final String setting) {
        throw new CustomModLoadingErrorDisplayException(){

            public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
            }

            @SideOnly(value=Side.CLIENT)
            public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
                errorScreen.func_73731_b(fontRenderer, "Compressed Blocks Config is invalid. Looking at compressed block: " + setting, errorScreen.field_146294_l / 2, errorScreen.field_146294_l / 2, 0);
            }
        };
    }
}

