/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.compressed;

import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.block.ModBlock;
import com.cjm721.overloaded.client.render.dynamic.compressed.block.CompressedBlockAssets;
import com.cjm721.overloaded.config.OverloadedConfig;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockCompressed
extends ModBlock {
    @Nonnull
    private final Block baseBlock;
    @Nonnull
    private final Block previousBlock;
    private final int compressionAmount;
    private final boolean recipeEnabled;

    BlockCompressed(@Nonnull Block baseBlock, @Nonnull Block previousBlock, int compressionAmount, @Nonnull Material materialIn, @Nonnull String registryName, @Nonnull String unlocalizedName, float hardness, String harvestTool, int harvestLevel, boolean recipeEnabled) {
        super(materialIn);
        this.baseBlock = baseBlock;
        this.previousBlock = previousBlock;
        this.compressionAmount = compressionAmount;
        this.recipeEnabled = recipeEnabled;
        this.setRegistryName(registryName);
        this.func_149663_c(unlocalizedName);
        this.func_149672_a(baseBlock.func_185467_w());
        this.func_149711_c(hardness);
        if (harvestTool != null) {
            this.setHarvestLevel(harvestTool, harvestLevel);
        }
        this.func_149647_a(OverloadedCreativeTabs.COMPRESSED_BLOCKS);
        this.register();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, EntityPlayer player, @Nonnull List<String> tooltip, boolean advanced) {
        tooltip.add(String.format("Hardness: %.0f", Float.valueOf(((ItemBlock)stack.func_77973_b()).func_179223_d().func_176223_P().func_185887_b(null, null))));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    @Override
    public void registerRecipe() {
        if (OverloadedConfig.recipeEnabledConfig.compressedBlocks && this.recipeEnabled) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this), (Object[])new Object[]{"AAA", "AAA", "AAA", Character.valueOf('A'), this.previousBlock});
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(this.previousBlock, 9), (Object[])new Object[]{this});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        CompressedBlockAssets.addToTextureQueue(new CompressedBlockAssets.CompressedResourceLocation((ResourceLocation)this.getBaseModelLocation(), this.getRegistryName(), this.getCompressionAmount()));
        ModelResourceLocation rl = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)rl);
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    private ModelResourceLocation getBaseModelLocation() {
        return new ModelResourceLocation(this.baseBlock.getRegistryName(), null);
    }

    @Nonnull
    public Block getBaseBlock() {
        return this.baseBlock;
    }

    public int getCompressionAmount() {
        return this.compressionAmount;
    }

    @Nonnull
    public String func_149732_F() {
        return this.baseBlock.func_149732_F();
    }
}

