/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.basic.container;

import com.cjm721.overloaded.OverloadedCreativeTabs;
import com.cjm721.overloaded.block.basic.container.AbstractBlockInfiniteContainer;
import com.cjm721.overloaded.block.tile.infinity.TileInfiniteTank;
import com.cjm721.overloaded.client.render.dynamic.general.ResizeableTextureGenerator;
import com.cjm721.overloaded.config.OverloadedConfig;
import com.cjm721.overloaded.item.ModItems;
import com.cjm721.overloaded.storage.IHyperType;
import com.cjm721.overloaded.storage.LongFluidStack;
import com.cjm721.overloaded.storage.fluid.IHyperHandlerFluid;
import com.cjm721.overloaded.util.CapabilityHyperFluid;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockInfiniteTank
extends AbstractBlockInfiniteContainer
implements ITileEntityProvider {
    public BlockInfiniteTank() {
        super(Material.field_151592_s);
        this.setRegistryName("infinite_tank");
        this.func_149663_c("infinite_tank");
        this.func_149711_c(10.0f);
        this.func_149713_g(0);
        this.func_149647_a(OverloadedCreativeTabs.TECH);
        this.register();
        GameRegistry.registerTileEntity(TileInfiniteTank.class, (String)"overloaded:infinite_tank");
    }

    @Override
    public void registerRecipe() {
        if (OverloadedConfig.recipeEnabledConfig.infinityTank) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Block)this), (Object[])new Object[]{"GDG", "DCD", "GDG", Character.valueOf('G'), Blocks.field_150339_S, Character.valueOf('D'), Blocks.field_150484_ah, Character.valueOf('C'), ModItems.fluidCore});
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "infinite_tank"), null);
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)location);
        ResizeableTextureGenerator.addToTextureQueue(new ResizeableTextureGenerator.ResizableTexture(new ResourceLocation("overloaded", "textures/blocks/infinite_tank.png"), new ResourceLocation("overloaded", "textures/dynamic/blocks/infinite_tank.png"), OverloadedConfig.textureResolutions.blockResolution));
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new TileInfiniteTank();
    }

    public boolean func_180639_a(@Nonnull World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack heldItem = playerIn.func_184586_b(hand);
            if (heldItem.func_190926_b() && hand == EnumHand.MAIN_HAND) {
                LongFluidStack storedFluid = ((TileInfiniteTank)worldIn.func_175625_s(pos)).getStorage().getFluidStack();
                if (storedFluid == null || storedFluid.fluidStack == null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString("Fluid: EMPTY"), false);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentString(String.format("Fluid: %s Amount %,d", storedFluid.fluidStack.getLocalizedName(), storedFluid.amount)), false);
                }
            } else {
                IFluidHandler handler;
                FluidActionResult result;
                TileEntity te = worldIn.func_175625_s(pos);
                if (te != null && te instanceof TileInfiniteTank && (result = FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)(handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)), (EntityPlayer)playerIn)).isSuccess()) {
                    playerIn.func_184611_a(hand, result.getResult());
                }
            }
        }
        return true;
    }

    @Override
    @Nullable
    protected IHyperType getHyperStack(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileInfiniteTank) {
            return ((IHyperHandlerFluid)te.getCapability(CapabilityHyperFluid.HYPER_FLUID_HANDLER, EnumFacing.UP)).status();
        }
        return null;
    }
}

