/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.okhttp3;

import java.io.IOException;
import java.util.ArrayList;
import net.shadowfacts.discordchat.repack.okhttp3.Call;
import net.shadowfacts.discordchat.repack.okhttp3.Callback;
import net.shadowfacts.discordchat.repack.okhttp3.EventListener;
import net.shadowfacts.discordchat.repack.okhttp3.Interceptor;
import net.shadowfacts.discordchat.repack.okhttp3.OkHttpClient;
import net.shadowfacts.discordchat.repack.okhttp3.Request;
import net.shadowfacts.discordchat.repack.okhttp3.Response;
import net.shadowfacts.discordchat.repack.okhttp3.internal.NamedRunnable;
import net.shadowfacts.discordchat.repack.okhttp3.internal.cache.CacheInterceptor;
import net.shadowfacts.discordchat.repack.okhttp3.internal.connection.ConnectInterceptor;
import net.shadowfacts.discordchat.repack.okhttp3.internal.connection.StreamAllocation;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http.BridgeInterceptor;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http.CallServerInterceptor;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http.RealInterceptorChain;
import net.shadowfacts.discordchat.repack.okhttp3.internal.http.RetryAndFollowUpInterceptor;
import net.shadowfacts.discordchat.repack.okhttp3.internal.platform.Platform;

final class RealCall
implements Call {
    final OkHttpClient client;
    final RetryAndFollowUpInterceptor retryAndFollowUpInterceptor;
    final EventListener eventListener;
    final Request originalRequest;
    final boolean forWebSocket;
    private boolean executed;

    RealCall(OkHttpClient client, Request originalRequest, boolean forWebSocket) {
        EventListener.Factory eventListenerFactory = client.eventListenerFactory();
        this.client = client;
        this.originalRequest = originalRequest;
        this.forWebSocket = forWebSocket;
        this.retryAndFollowUpInterceptor = new RetryAndFollowUpInterceptor(client, forWebSocket);
        this.eventListener = eventListenerFactory.create(this);
    }

    @Override
    public Request request() {
        return this.originalRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response execute() throws IOException {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.captureCallStackTrace();
        try {
            this.client.dispatcher().executed(this);
            Response result = this.getResponseWithInterceptorChain();
            if (result == null) {
                throw new IOException("Canceled");
            }
            Response response = result;
            return response;
        }
        finally {
            this.client.dispatcher().finished(this);
        }
    }

    private void captureCallStackTrace() {
        Object callStackTrace = Platform.get().getStackTraceForCloseable("response.body().close()");
        this.retryAndFollowUpInterceptor.setCallStackTrace(callStackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(Callback responseCallback) {
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.captureCallStackTrace();
        this.client.dispatcher().enqueue(new AsyncCall(responseCallback));
    }

    @Override
    public void cancel() {
        this.retryAndFollowUpInterceptor.cancel();
    }

    @Override
    public synchronized boolean isExecuted() {
        return this.executed;
    }

    @Override
    public boolean isCanceled() {
        return this.retryAndFollowUpInterceptor.isCanceled();
    }

    @Override
    public RealCall clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    StreamAllocation streamAllocation() {
        return this.retryAndFollowUpInterceptor.streamAllocation();
    }

    String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl();
    }

    String redactedUrl() {
        return this.originalRequest.url().redact();
    }

    Response getResponseWithInterceptorChain() throws IOException {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        interceptors.addAll(this.client.interceptors());
        interceptors.add(this.retryAndFollowUpInterceptor);
        interceptors.add(new BridgeInterceptor(this.client.cookieJar()));
        interceptors.add(new CacheInterceptor(this.client.internalCache()));
        interceptors.add(new ConnectInterceptor(this.client));
        if (!this.forWebSocket) {
            interceptors.addAll(this.client.networkInterceptors());
        }
        interceptors.add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain chain = new RealInterceptorChain(interceptors, null, null, null, 0, this.originalRequest);
        return chain.proceed(this.originalRequest);
    }

    final class AsyncCall
    extends NamedRunnable {
        private final Callback responseCallback;

        AsyncCall(Callback responseCallback) {
            super("OkHttp %s", RealCall.this.redactedUrl());
            this.responseCallback = responseCallback;
        }

        String host() {
            return RealCall.this.originalRequest.url().host();
        }

        Request request() {
            return RealCall.this.originalRequest;
        }

        RealCall get() {
            return RealCall.this;
        }

        @Override
        protected void execute() {
            boolean signalledCallback = false;
            try {
                Response response = RealCall.this.getResponseWithInterceptorChain();
                if (RealCall.this.retryAndFollowUpInterceptor.isCanceled()) {
                    signalledCallback = true;
                    this.responseCallback.onFailure(RealCall.this, new IOException("Canceled"));
                } else {
                    signalledCallback = true;
                    this.responseCallback.onResponse(RealCall.this, response);
                }
            }
            catch (IOException e) {
                if (signalledCallback) {
                    Platform.get().log(4, "Callback failure for " + RealCall.this.toLoggableString(), e);
                } else {
                    this.responseCallback.onFailure(RealCall.this, e);
                }
            }
            finally {
                RealCall.this.client.dispatcher().finished(this);
            }
        }
    }
}

