/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.order;

import java.util.List;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.order.OrderAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.okhttp3.RequestBody;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class ChannelOrderAction<T extends Channel>
extends OrderAction<T, ChannelOrderAction<T>> {
    protected final Guild guild;
    protected final ChannelType type;

    public ChannelOrderAction(Guild guild, ChannelType type) {
        super(guild.getJDA(), Route.Guilds.MODIFY_CHANNELS.compile(guild.getId()));
        this.guild = guild;
        this.type = type;
        List<Channel> chans = type == ChannelType.TEXT ? guild.getTextChannels() : guild.getVoiceChannels();
        this.orderList.addAll(chans);
    }

    public Guild getGuild() {
        return this.guild;
    }

    public ChannelType getChannelType() {
        return this.type;
    }

    @Override
    protected RequestBody finalizeData() {
        Member self = this.guild.getSelfMember();
        if (!self.hasPermission(Permission.MANAGE_CHANNEL)) {
            throw new PermissionException(Permission.MANAGE_CHANNEL);
        }
        JSONArray array = new JSONArray();
        for (int i = 0; i < this.orderList.size(); ++i) {
            Channel chan = (Channel)this.orderList.get(i);
            array.put(new JSONObject().put("id", chan.getId()).put("position", i));
        }
        return this.getRequestBody(array);
    }

    @Override
    protected void validateInput(T entity) {
        Checks.check(entity.getGuild().equals(this.guild), "Provided channel is not from this Guild!");
        Checks.check(this.orderList.contains(entity), "Provided channel is not in the list of orderable channels!");
    }
}

