/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction;

import java.util.concurrent.TimeUnit;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Invite;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.okhttp3.RequestBody;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class InviteAction
extends AuditableRestAction<Invite> {
    private Integer maxAge = null;
    private Integer maxUses = null;
    private Boolean temporary = null;
    private Boolean unique = null;

    public InviteAction(JDA api, String channelId) {
        super(api, Route.Invites.CREATE_INVITE.compile(channelId));
    }

    @Override
    protected RequestBody finalizeData() {
        JSONObject object = new JSONObject();
        if (this.maxAge != null) {
            object.put("max_age", this.maxAge);
        }
        if (this.maxUses != null) {
            object.put("max_uses", this.maxUses);
        }
        if (this.temporary != null) {
            object.put("temporary", this.temporary);
        }
        if (this.unique != null) {
            object.put("unique", this.unique);
        }
        return this.getRequestBody(object);
    }

    @Override
    protected void handleResponse(Response response, Request<Invite> request) {
        if (response.isOk()) {
            request.onSuccess(this.api.getEntityBuilder().createInvite(response.getObject()));
        } else {
            request.onFailure(response);
        }
    }

    public final InviteAction setMaxAge(Integer maxAge) {
        if (maxAge != null) {
            Checks.notNegative(maxAge, "maxAge");
        }
        this.maxAge = maxAge;
        return this;
    }

    public final InviteAction setMaxAge(Long maxAge, TimeUnit timeUnit) {
        if (maxAge == null) {
            return this.setMaxAge(null);
        }
        Checks.notNegative(maxAge, "maxAge");
        Checks.notNull((Object)timeUnit, "timeUnit");
        return this.setMaxAge(Math.toIntExact(timeUnit.toSeconds(maxAge)));
    }

    public final InviteAction setMaxUses(Integer maxUses) {
        if (maxUses != null) {
            Checks.notNegative(maxUses, "maxUses");
        }
        this.maxUses = maxUses;
        return this;
    }

    public final InviteAction setTemporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public final InviteAction setUnique(Boolean unique) {
        this.unique = unique;
        return this;
    }
}

