/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.ratelimit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.events.ExceptionEvent;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RateLimiter;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Requester;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.ratelimit.IBucket;
import net.shadowfacts.discordchat.repack.okhttp3.Response;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;
import net.shadowfacts.discordchat.repack.org.json.JSONTokener;

public class ClientRateLimiter
extends RateLimiter {
    volatile Long globalCooldown = null;

    public ClientRateLimiter(Requester requester, int poolSize) {
        super(requester, poolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getRateLimit(Route.CompiledRoute route) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route);
        synchronized (bucket2) {
            return bucket.getRateLimit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueRequest(Request request) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(request.getRoute());
        synchronized (bucket2) {
            bucket.addToQueue(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Long handleResponse(Route.CompiledRoute route, Response response) {
        Bucket bucket;
        Bucket bucket2 = bucket = this.getBucket(route);
        synchronized (bucket2) {
            long now = System.currentTimeMillis();
            int code = response.code();
            if (code != 429) {
                return null;
            }
            try (InputStream in = Requester.getBody(response);){
                JSONObject limitObj = new JSONObject(new JSONTokener(in));
                long retryAfter = limitObj.getLong("retry_after");
                if (limitObj.has("global") && limitObj.getBoolean("global")) {
                    this.globalCooldown = now + retryAfter;
                } else {
                    bucket.retryAfter = now + retryAfter;
                }
                Long l = retryAfter;
                return l;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getBucket(Route.CompiledRoute route) {
        String baseRoute = route.getBaseRoute().getRoute();
        Bucket bucket = (Bucket)this.buckets.get(baseRoute);
        if (bucket == null) {
            ConcurrentHashMap concurrentHashMap = this.buckets;
            synchronized (concurrentHashMap) {
                bucket = (Bucket)this.buckets.get(baseRoute);
                if (bucket == null) {
                    bucket = new Bucket(baseRoute, route.getBaseRoute().getRatelimit());
                    this.buckets.put(baseRoute, bucket);
                }
            }
        }
        return bucket;
    }

    private class Bucket
    implements IBucket,
    Runnable {
        final String route;
        final Route.RateLimit rateLimit;
        volatile long retryAfter = 0L;
        volatile ConcurrentLinkedQueue<Request> requests = new ConcurrentLinkedQueue();

        public Bucket(String route, Route.RateLimit rateLimit) {
            this.route = route;
            this.rateLimit = rateLimit;
        }

        void addToQueue(Request request) {
            this.requests.add(request);
            this.submitForProcessing();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void submitForProcessing() {
            ConcurrentLinkedQueue concurrentLinkedQueue = ClientRateLimiter.this.submittedBuckets;
            synchronized (concurrentLinkedQueue) {
                if (!ClientRateLimiter.this.submittedBuckets.contains(this)) {
                    Long delay = this.getRateLimit();
                    if (delay == null) {
                        delay = 0L;
                    }
                    ClientRateLimiter.this.pool.schedule(this, (long)delay, TimeUnit.MILLISECONDS);
                    ClientRateLimiter.this.submittedBuckets.add(this);
                }
            }
        }

        Long getRateLimit() {
            long now = System.currentTimeMillis();
            if (ClientRateLimiter.this.globalCooldown != null) {
                if (now > ClientRateLimiter.this.globalCooldown) {
                    ClientRateLimiter.this.globalCooldown = null;
                } else {
                    return ClientRateLimiter.this.globalCooldown - now;
                }
            }
            if (this.retryAfter > now) {
                return this.retryAfter - now;
            }
            return null;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Bucket)) {
                return false;
            }
            Bucket oBucket = (Bucket)o;
            return this.route.equals(oBucket.route);
        }

        public int hashCode() {
            return this.route.hashCode();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block14: {
                try {
                    ConcurrentLinkedQueue<Request> concurrentLinkedQueue = this.requests;
                    synchronized (concurrentLinkedQueue) {
                        Object it = this.requests.iterator();
                        while (it.hasNext()) {
                            Request request = null;
                            try {
                                request = it.next();
                                Long retryAfter = ClientRateLimiter.this.requester.execute(request);
                                if (retryAfter != null) break;
                                it.remove();
                            }
                            catch (Throwable t) {
                                Requester.LOG.fatal("Requester system encountered an internal error");
                                Requester.LOG.log(t);
                                it.remove();
                                if (request == null) continue;
                                request.onFailure(t);
                            }
                        }
                        it = ClientRateLimiter.this.submittedBuckets;
                        synchronized (it) {
                            ClientRateLimiter.this.submittedBuckets.remove(this);
                            if (!this.requests.isEmpty()) {
                                try {
                                    this.submitForProcessing();
                                }
                                catch (RejectedExecutionException e) {
                                    Requester.LOG.debug("Caught RejectedExecutionException when re-queuing a ratelimited request. The requester is probably shutdown, thus, this can be ignored.");
                                }
                            }
                        }
                    }
                }
                catch (Throwable err) {
                    Requester.LOG.fatal("Requester system encountered an internal error from beyond the synchronized execution blocks. NOT GOOD!");
                    Requester.LOG.log(err);
                    if (!(err instanceof Error)) break block14;
                    JDAImpl api = ClientRateLimiter.this.requester.getJDA();
                    api.getEventManager().handle(new ExceptionEvent(api, err, true));
                }
            }
        }

        @Override
        public Route.RateLimit getRatelimit() {
            return this.rateLimit;
        }

        @Override
        public String getRoute() {
            return this.route;
        }

        @Override
        public Queue<Request> getRequests() {
            return this.requests;
        }
    }
}

