/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.ErrorResponseException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.RateLimitedException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RequestFuture;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Requester;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestFuture;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.SimpleLog;
import net.shadowfacts.discordchat.repack.okhttp3.RequestBody;
import net.shadowfacts.discordchat.repack.org.apache.commons.collections4.map.CaseInsensitiveMap;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public abstract class RestAction<T> {
    public static final SimpleLog LOG = SimpleLog.getLog("RestAction");
    public static Consumer DEFAULT_SUCCESS = o -> {};
    public static Consumer<Throwable> DEFAULT_FAILURE = t -> {
        if (LOG.getEffectiveLevel().getPriority() <= SimpleLog.Level.DEBUG.getPriority()) {
            LOG.log((Throwable)t);
        } else {
            LOG.fatal("RestAction queue returned failure: [" + t.getClass().getSimpleName() + "] " + t.getMessage());
        }
    };
    protected final JDAImpl api;
    private final Route.CompiledRoute route;
    private final RequestBody data;
    private Object rawData;

    public RestAction(JDA api, Route.CompiledRoute route) {
        this(api, route, (RequestBody)null);
    }

    public RestAction(JDA api, Route.CompiledRoute route, RequestBody data) {
        Checks.notNull(api, "api");
        this.api = (JDAImpl)api;
        this.route = route;
        this.data = data;
    }

    public RestAction(JDA api, Route.CompiledRoute route, JSONObject data) {
        this(api, route, data == null ? null : RequestBody.create(Requester.MEDIA_TYPE_JSON, data.toString()));
        this.rawData = data;
    }

    public JDA getJDA() {
        return this.api;
    }

    public void queue() {
        this.queue(null, null);
    }

    public void queue(Consumer<T> success) {
        this.queue(success, null);
    }

    public void queue(Consumer<T> success, Consumer<Throwable> failure) {
        Route.CompiledRoute route = this.finalizeRoute();
        Checks.notNull(route, "Route");
        RequestBody data = this.finalizeData();
        CaseInsensitiveMap<String, String> headers = this.finalizeHeaders();
        if (success == null) {
            success = DEFAULT_SUCCESS;
        }
        if (failure == null) {
            failure = DEFAULT_FAILURE;
        }
        this.api.getRequester().request(new Request(this, success, failure, true, data, this.rawData, route, headers));
    }

    public RequestFuture<T> submit() {
        return this.submit(true);
    }

    public RequestFuture<T> submit(boolean shouldQueue) {
        Route.CompiledRoute route = this.finalizeRoute();
        Checks.notNull(route, "Route");
        RequestBody data = this.finalizeData();
        CaseInsensitiveMap<String, String> headers = this.finalizeHeaders();
        return new RestFuture(this, shouldQueue, data, this.rawData, route, headers);
    }

    public T complete() {
        try {
            return this.complete(true);
        }
        catch (RateLimitedException ignored) {
            throw new RuntimeException(ignored);
        }
    }

    public T complete(boolean shouldQueue) throws RateLimitedException {
        try {
            return (T)this.submit(shouldQueue).get();
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException) {
                Throwable t = e.getCause();
                if (t instanceof RateLimitedException) {
                    throw (RateLimitedException)t;
                }
                if (t instanceof PermissionException) {
                    throw (PermissionException)t;
                }
                if (t instanceof ErrorResponseException) {
                    throw (ErrorResponseException)t;
                }
            }
            throw new RuntimeException(e);
        }
    }

    public ScheduledFuture<T> submitAfter(long delay, TimeUnit unit) {
        return this.submitAfter(delay, unit, this.api.pool);
    }

    public ScheduledFuture<T> submitAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        Checks.notNull(executor, "Scheduler");
        Checks.notNull((Object)unit, "TimeUnit");
        return executor.schedule(this::complete, delay, unit);
    }

    public T completeAfter(long delay, TimeUnit unit) {
        Checks.notNull((Object)unit, "TimeUnit");
        try {
            unit.sleep(delay);
            return this.complete();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit) {
        return this.queueAfter(delay, unit, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success) {
        return this.queueAfter(delay, unit, success, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success, Consumer<Throwable> failure) {
        return this.queueAfter(delay, unit, success, failure, this.api.pool);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, null, executor);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success, ScheduledExecutorService executor) {
        return this.queueAfter(delay, unit, success, null, executor);
    }

    public ScheduledFuture<?> queueAfter(long delay, TimeUnit unit, Consumer<T> success, Consumer<Throwable> failure, ScheduledExecutorService executor) {
        Checks.notNull(executor, "Scheduler");
        Checks.notNull((Object)unit, "TimeUnit");
        return executor.schedule(() -> this.queue(success, failure), delay, unit);
    }

    protected RequestBody finalizeData() {
        return this.data;
    }

    protected Route.CompiledRoute finalizeRoute() {
        return this.route;
    }

    protected CaseInsensitiveMap<String, String> finalizeHeaders() {
        return null;
    }

    protected RequestBody getRequestBody(JSONObject object) {
        this.rawData = object;
        return object == null ? null : RequestBody.create(Requester.MEDIA_TYPE_JSON, object.toString());
    }

    protected RequestBody getRequestBody(JSONArray array) {
        this.rawData = array;
        return array == null ? null : RequestBody.create(Requester.MEDIA_TYPE_JSON, array.toString());
    }

    protected abstract void handleResponse(Response var1, Request<T> var2);

    public static class FailedRestAction<T>
    extends RestAction<T> {
        private final Exception exception;

        public FailedRestAction(Exception exception) {
            super(null, null);
            this.exception = exception;
        }

        @Override
        public void queue(Consumer<T> success, Consumer<Throwable> failure) {
            if (failure != null) {
                failure.accept(this.exception);
            }
        }

        @Override
        public RequestFuture<T> submit(boolean shouldQueue) {
            return new RestFuture(this.exception);
        }

        @Override
        public T complete(boolean shouldQueue) {
            throw new RuntimeException(this.exception);
        }

        @Override
        protected void handleResponse(Response response, Request<T> request) {
        }
    }

    public static class EmptyRestAction<T>
    extends RestAction<T> {
        private final T returnObj;

        public EmptyRestAction(JDA api, T returnObj) {
            super(api, null);
            this.returnObj = returnObj;
        }

        @Override
        public void queue(Consumer<T> success, Consumer<Throwable> failure) {
            if (success != null) {
                success.accept(this.returnObj);
            }
        }

        @Override
        public RequestFuture<T> submit(boolean shouldQueue) {
            return new RestFuture<T>(this.returnObj);
        }

        @Override
        public T complete(boolean shouldQueue) {
            return this.returnObj;
        }

        @Override
        protected void handleResponse(Response response, Request<T> request) {
        }
    }
}

