/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.impl;

import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.OnlineStatus;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Game;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.managers.Presence;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class PresenceImpl
implements Presence {
    private final JDAImpl api;
    private boolean idle = false;
    private Game game = null;
    private OnlineStatus status = OnlineStatus.ONLINE;

    public PresenceImpl(JDAImpl jda) {
        this.api = jda;
    }

    @Override
    public JDA getJDA() {
        return this.api;
    }

    @Override
    public OnlineStatus getStatus() {
        return this.status;
    }

    @Override
    public Game getGame() {
        return this.game;
    }

    @Override
    public boolean isIdle() {
        return this.idle;
    }

    @Override
    public void setStatus(OnlineStatus status) {
        this.setPresence(status, this.game, this.idle);
    }

    @Override
    public void setGame(Game game) {
        this.setPresence(this.status, game, this.idle);
    }

    @Override
    public void setIdle(boolean idle) {
        this.setPresence(this.status, this.game, idle);
    }

    @Override
    public void setPresence(OnlineStatus status, Game game, boolean idle) {
        JSONObject gameObj = this.getGameJson(game);
        Checks.check(status != OnlineStatus.UNKNOWN, "Cannot set the presence status to an unknown OnlineStatus!");
        if (status == OnlineStatus.OFFLINE || status == null) {
            status = OnlineStatus.INVISIBLE;
        }
        JSONObject object = new JSONObject();
        if (gameObj == null) {
            object.put("game", JSONObject.NULL);
        } else {
            object.put("game", gameObj);
        }
        object.put("afk", idle);
        object.put("status", status.getKey());
        object.put("since", System.currentTimeMillis());
        this.update(object);
        this.idle = idle;
        this.status = status;
        this.game = gameObj == null ? null : game;
    }

    @Override
    public void setPresence(OnlineStatus status, Game game) {
        JSONObject gameObj = this.getGameJson(game);
        Checks.check(status != OnlineStatus.UNKNOWN, "Cannot set the presence status to an unknown OnlineStatus!");
        if (status == OnlineStatus.OFFLINE || status == null) {
            status = OnlineStatus.INVISIBLE;
        }
        JSONObject object = new JSONObject();
        if (gameObj == null) {
            object.put("game", JSONObject.NULL);
        } else {
            object.put("game", gameObj);
        }
        object.put("status", status.getKey());
        object.put("since", System.currentTimeMillis());
        this.update(object);
        this.status = status;
        this.game = gameObj == null ? null : game;
    }

    @Override
    public void setPresence(OnlineStatus status, boolean idle) {
        Checks.check(status != OnlineStatus.UNKNOWN, "Cannot set the presence status to an unknown OnlineStatus!");
        if (status == OnlineStatus.OFFLINE || status == null) {
            status = OnlineStatus.INVISIBLE;
        }
        JSONObject object = new JSONObject();
        object.put("afk", idle);
        object.put("status", status.getKey());
        object.put("since", System.currentTimeMillis());
        this.update(object);
        this.idle = idle;
        this.status = status;
    }

    @Override
    public void setPresence(Game game, boolean idle) {
        JSONObject gameObj = this.getGameJson(game);
        JSONObject object = new JSONObject();
        if (gameObj == null) {
            object.put("game", JSONObject.NULL);
        } else {
            object.put("game", gameObj);
        }
        object.put("afk", idle);
        object.put("since", System.currentTimeMillis());
        this.update(object);
        this.idle = idle;
        this.game = gameObj == null ? null : game;
    }

    public PresenceImpl setCacheStatus(OnlineStatus status) {
        if (status == null) {
            throw new NullPointerException("Null OnlineStatus is not allowed.");
        }
        if (status == OnlineStatus.OFFLINE) {
            status = OnlineStatus.INVISIBLE;
        }
        this.status = status;
        return this;
    }

    public PresenceImpl setCacheGame(Game game) {
        this.game = game;
        return this;
    }

    public PresenceImpl setCacheIdle(boolean idle) {
        this.idle = idle;
        return this;
    }

    public JSONObject getFullPresence() {
        JSONObject game = this.getGameJson(this.game);
        return new JSONObject().put("afk", this.idle).put("since", System.currentTimeMillis()).put("game", game == null ? JSONObject.NULL : game).put("status", this.getStatus().getKey());
    }

    private JSONObject getGameJson(Game game) {
        if (game == null || game.getName() == null || game.getType() == null) {
            return null;
        }
        JSONObject gameObj = new JSONObject();
        gameObj.put("name", game.getName());
        gameObj.put("type", game.getType().getKey());
        if (game.getType() == Game.GameType.TWITCH && game.getUrl() != null) {
            gameObj.put("url", game.getUrl());
        }
        return gameObj;
    }

    protected void update(JSONObject data) {
        this.api.getClient().send(new JSONObject().put("d", data).put("op", 3).toString());
    }
}

