/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl;

import java.io.InputStream;
import java.time.OffsetDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.exceptions.VerificationLevelException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.EntityBuilder;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ISnowflake;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Member;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Message;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageHistory;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Webhook;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.AbstractChannelImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.GuildImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.impl.JDAImpl;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.AuditableRestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.MiscUtil;
import net.shadowfacts.discordchat.repack.org.json.JSONArray;
import net.shadowfacts.discordchat.repack.org.json.JSONException;
import net.shadowfacts.discordchat.repack.org.json.JSONObject;

public class TextChannelImpl
extends AbstractChannelImpl<TextChannelImpl>
implements TextChannel {
    private String topic;
    private long lastMessageId;

    public TextChannelImpl(long id, GuildImpl guild) {
        super(id, guild);
    }

    @Override
    public String getAsMention() {
        return "<#" + this.id + '>';
    }

    @Override
    public RestAction<List<Webhook>> getWebhooks() {
        this.checkPermission(Permission.MANAGE_WEBHOOKS);
        Route.CompiledRoute route = Route.Channels.GET_WEBHOOKS.compile(this.getId());
        return new RestAction<List<Webhook>>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<List<Webhook>> request) {
                if (!response.isOk()) {
                    request.onFailure(response);
                    return;
                }
                LinkedList<Webhook> webhooks = new LinkedList<Webhook>();
                JSONArray array = response.getArray();
                EntityBuilder builder = this.api.getEntityBuilder();
                for (Object object : array) {
                    try {
                        webhooks.add(builder.createWebhook((JSONObject)object));
                    }
                    catch (NullPointerException | JSONException e) {
                        JDAImpl.LOG.log(e);
                    }
                }
                request.onSuccess(webhooks);
            }
        };
    }

    @Override
    public RestAction<Void> deleteMessages(Collection<Message> messages) {
        Checks.notEmpty(messages, "Messages collection");
        return this.deleteMessagesByIds(messages.stream().map(ISnowflake::getId).collect(Collectors.toList()));
    }

    @Override
    public RestAction<Void> deleteMessagesByIds(Collection<String> messageIds) {
        this.checkPermission(Permission.MESSAGE_MANAGE, "Must have MESSAGE_MANAGE in order to bulk delete messages in this channel regardless of author.");
        if (messageIds.size() < 2 || messageIds.size() > 100) {
            throw new IllegalArgumentException("Must provide at least 2 or at most 100 messages to be deleted.");
        }
        long twoWeeksAgo = System.currentTimeMillis() - 1209600000L - 1420070400000L << 22;
        for (String id : messageIds) {
            Checks.notEmpty(id, "Message id in messageIds");
            Checks.check(MiscUtil.parseSnowflake(id) > twoWeeksAgo, "Message Id provided was older than 2 weeks. Id: " + id);
        }
        JSONObject body = new JSONObject().put("messages", messageIds);
        Route.CompiledRoute route = Route.Messages.DELETE_MESSAGES.compile(this.getId());
        return new RestAction<Void>(this.getJDA(), route, body){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public AuditableRestAction<Void> deleteWebhookById(String id) {
        Checks.notEmpty(id, "webhook id");
        if (!this.guild.getSelfMember().hasPermission((Channel)this, Permission.MANAGE_WEBHOOKS)) {
            throw new PermissionException(Permission.MANAGE_WEBHOOKS);
        }
        Route.CompiledRoute route = Route.Webhooks.DELETE_WEBHOOK.compile(id);
        return new AuditableRestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public boolean canTalk() {
        return this.canTalk(this.guild.getSelfMember());
    }

    @Override
    public boolean canTalk(Member member) {
        if (!this.guild.equals(member.getGuild())) {
            throw new IllegalArgumentException("Provided Member is not from the Guild that this TextChannel is part of.");
        }
        return member.hasPermission((Channel)this, Permission.MESSAGE_READ, Permission.MESSAGE_WRITE);
    }

    @Override
    public long getLatestMessageIdLong() {
        long messageId = this.lastMessageId;
        if (messageId < 0L) {
            throw new IllegalStateException("No last message id found.");
        }
        return messageId;
    }

    @Override
    public boolean hasLatestMessage() {
        return this.lastMessageId > 0L;
    }

    @Override
    public ChannelType getType() {
        return ChannelType.TEXT;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public boolean isNSFW() {
        return this.name.equals("nsfw") || this.name.startsWith("nsfw-");
    }

    @Override
    public List<Member> getMembers() {
        return Collections.unmodifiableList(this.guild.getMembersMap().valueCollection().stream().filter(m -> m.hasPermission((Channel)this, Permission.MESSAGE_READ)).collect(Collectors.toList()));
    }

    @Override
    public int getPosition() {
        List<TextChannel> channels = this.guild.getTextChannels();
        for (int i = 0; i < channels.size(); ++i) {
            if (channels.get(i) != this) continue;
            return i;
        }
        throw new RuntimeException("Somehow when determining position we never found the TextChannel in the Guild's channels? wtf?");
    }

    @Override
    public RestAction<Message> sendMessage(Message msg) {
        Checks.notNull(msg, "Message");
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (msg.getRawContent().isEmpty() && !msg.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.sendMessage(msg);
    }

    @Override
    public RestAction<Message> sendFile(InputStream data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        return TextChannel.super.sendFile(data, fileName, message);
    }

    @Override
    public RestAction<Message> sendFile(byte[] data, String fileName, Message message) {
        this.checkVerification();
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        this.checkPermission(Permission.MESSAGE_ATTACH_FILES);
        return TextChannel.super.sendFile(data, fileName, message);
    }

    @Override
    public RestAction<Message> getMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.getMessageById(messageId);
    }

    @Override
    public AuditableRestAction<Void> deleteMessageById(String messageId) {
        Checks.notEmpty(messageId, "messageId");
        this.checkPermission(Permission.MESSAGE_READ);
        return TextChannel.super.deleteMessageById(messageId);
    }

    @Override
    public RestAction<MessageHistory> getHistoryAround(String messageId, int limit) {
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.getHistoryAround(messageId, limit);
    }

    @Override
    public RestAction<Void> pinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot pin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.pinMessageById(messageId);
    }

    @Override
    public RestAction<Void> unpinMessageById(String messageId) {
        this.checkPermission(Permission.MESSAGE_READ, "You cannot unpin a message in a channel you can't access. (MESSAGE_READ)");
        this.checkPermission(Permission.MESSAGE_MANAGE, "You need MESSAGE_MANAGE to pin or unpin messages.");
        return TextChannel.super.unpinMessageById(messageId);
    }

    @Override
    public RestAction<List<Message>> getPinnedMessages() {
        this.checkPermission(Permission.MESSAGE_READ, "Cannot get the pinned message of a channel without MESSAGE_READ access.");
        return TextChannel.super.getPinnedMessages();
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, String unicode) {
        this.checkPermission(Permission.MESSAGE_ADD_REACTION);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.addReactionById(messageId, unicode);
    }

    @Override
    public RestAction<Void> addReactionById(String messageId, Emote emote) {
        this.checkPermission(Permission.MESSAGE_ADD_REACTION);
        this.checkPermission(Permission.MESSAGE_HISTORY);
        return TextChannel.super.addReactionById(messageId, emote);
    }

    @Override
    public RestAction<Void> clearReactionsById(String messageId) {
        Checks.notEmpty(messageId, "Message ID");
        this.checkPermission(Permission.MESSAGE_MANAGE);
        Route.CompiledRoute route = Route.Messages.REMOVE_ALL_REACTIONS.compile(this.getId(), messageId);
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    @Override
    public RestAction<Message> editMessageById(String id, Message newContent) {
        Checks.notNull(newContent, "Message");
        this.checkPermission(Permission.MESSAGE_READ);
        this.checkPermission(Permission.MESSAGE_WRITE);
        if (newContent.getRawContent().isEmpty() && !newContent.getEmbeds().isEmpty()) {
            this.checkPermission(Permission.MESSAGE_EMBED_LINKS);
        }
        return TextChannel.super.editMessageById(id, newContent);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TextChannelImpl)) {
            return false;
        }
        TextChannelImpl oTChannel = (TextChannelImpl)o;
        return this == oTChannel || this.id == oTChannel.id;
    }

    public String toString() {
        return "TC:" + this.getName() + '(' + this.id + ')';
    }

    @Override
    public int compareTo(TextChannel chan) {
        if (this == chan) {
            return 0;
        }
        if (!this.getGuild().equals(chan.getGuild())) {
            throw new IllegalArgumentException("Cannot compare TextChannels that aren't from the same guild!");
        }
        if (this.getPositionRaw() != chan.getPositionRaw()) {
            return chan.getPositionRaw() - this.getPositionRaw();
        }
        OffsetDateTime thisTime = this.getCreationTime();
        OffsetDateTime chanTime = chan.getCreationTime();
        return chanTime.compareTo(thisTime);
    }

    public TextChannelImpl setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public TextChannelImpl setLastMessageId(long id) {
        this.lastMessageId = id;
        return this;
    }

    private void checkVerification() {
        if (!this.guild.checkVerification()) {
            throw new VerificationLevelException(this.guild.getVerificationLevel());
        }
    }
}

