/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities;

import java.util.Objects;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.client.entities.Group;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.JDA;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.Permission;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Channel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ChannelType;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Emote;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.Guild;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.ISnowflake;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.MessageChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.PrivateChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.TextChannel;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities.User;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.exceptions.PermissionException;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Request;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Response;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.RestAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.Route;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.requests.restaction.pagination.ReactionPaginationAction;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.MiscUtil;

public class MessageReaction {
    private final MessageChannel channel;
    private final ReactionEmote emote;
    private final long messageId;
    private final boolean self;
    private final int count;

    public MessageReaction(MessageChannel channel, ReactionEmote emote, long messageId, boolean self, int count) {
        this.channel = channel;
        this.emote = emote;
        this.messageId = messageId;
        this.self = self;
        this.count = count;
    }

    public JDA getJDA() {
        return this.channel.getJDA();
    }

    public boolean isSelf() {
        return this.self;
    }

    public int getCount() {
        return this.count;
    }

    public ChannelType getChannelType() {
        return this.channel.getType();
    }

    public boolean isFromType(ChannelType type) {
        return this.getChannelType() == type;
    }

    public Guild getGuild() {
        TextChannel channel = this.getTextChannel();
        return channel != null ? channel.getGuild() : null;
    }

    public TextChannel getTextChannel() {
        return this.getChannel() instanceof TextChannel ? (TextChannel)this.getChannel() : null;
    }

    public PrivateChannel getPrivateChannel() {
        return this.getChannel() instanceof PrivateChannel ? (PrivateChannel)this.getChannel() : null;
    }

    public Group getGroup() {
        return this.getChannel() instanceof Group ? (Group)this.getChannel() : null;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public ReactionEmote getEmote() {
        return this.emote;
    }

    public String getMessageId() {
        return Long.toUnsignedString(this.messageId);
    }

    public long getMessageIdLong() {
        return this.messageId;
    }

    public ReactionPaginationAction getUsers() {
        return this.getUsers(100);
    }

    public ReactionPaginationAction getUsers(int amount) {
        return (ReactionPaginationAction)new ReactionPaginationAction(this).limit(amount);
    }

    public RestAction<Void> removeReaction() {
        return this.removeReaction(this.getJDA().getSelfUser());
    }

    public RestAction<Void> removeReaction(User user) {
        if (user == null) {
            throw new IllegalArgumentException("Provided User was null!");
        }
        if (!user.equals(this.getJDA().getSelfUser())) {
            if (this.channel.getType() == ChannelType.TEXT) {
                Channel channel = (Channel)((Object)this.channel);
                if (!channel.getGuild().getSelfMember().hasPermission(channel, Permission.MESSAGE_MANAGE)) {
                    throw new PermissionException(Permission.MESSAGE_MANAGE);
                }
            } else {
                throw new PermissionException("Unable to remove Reaction of other user in non-text channel!");
            }
        }
        String code = this.emote.isEmote() ? this.emote.getName() + ":" + this.emote.getId() : MiscUtil.encodeUTF8(this.emote.getName());
        Route.CompiledRoute route = Route.Messages.REMOVE_REACTION.compile(this.channel.getId(), this.getMessageId(), code, user.getId());
        return new RestAction<Void>(this.getJDA(), route){

            @Override
            protected void handleResponse(Response response, Request<Void> request) {
                if (response.isOk()) {
                    request.onSuccess(null);
                } else {
                    request.onFailure(response);
                }
            }
        };
    }

    public boolean equals(Object obj) {
        return obj instanceof MessageReaction && ((MessageReaction)obj).emote.equals(this.emote) && ((MessageReaction)obj).self == this.self && ((MessageReaction)obj).messageId == this.messageId;
    }

    public String toString() {
        return "MR:(M:(" + this.messageId + ") / " + this.emote + ")";
    }

    public static class ReactionEmote
    implements ISnowflake {
        private final JDA api;
        private final String name;
        private final Long id;
        private Emote emote = null;

        public ReactionEmote(String name, Long id, JDA api) {
            this.name = name;
            this.id = id;
            this.api = api;
        }

        public ReactionEmote(Emote emote) {
            this(emote.getName(), emote.getIdLong(), emote.getJDA());
            this.emote = emote;
        }

        public boolean isEmote() {
            return this.emote != null;
        }

        @Override
        public String getId() {
            return this.id != null ? String.valueOf(this.id) : null;
        }

        @Override
        public long getIdLong() {
            if (this.id == null) {
                throw new IllegalStateException("No id available");
            }
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public Emote getEmote() {
            return this.emote;
        }

        public JDA getJDA() {
            return this.api;
        }

        public boolean equals(Object obj) {
            return obj instanceof ReactionEmote && Objects.equals(((ReactionEmote)obj).id, this.id) && ((ReactionEmote)obj).getName().equals(this.name);
        }

        public String toString() {
            return "RE:" + (this.isEmote() ? this.getEmote() : this.getName() + "(" + this.id + ")");
        }
    }
}

