/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.entities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.Checks;
import net.shadowfacts.discordchat.repack.net.dv8tion.jda.core.utils.IOUtil;

public class Icon {
    protected final String encoding;

    protected Icon(String base64Encoding) {
        this.encoding = "data:image/jpeg;base64," + base64Encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public static Icon from(File file) throws IOException {
        Checks.notNull(file, "Provided File");
        Checks.check(file.exists(), "Provided file does not exist!");
        return Icon.from(IOUtil.readFully(file));
    }

    public static Icon from(InputStream stream) throws IOException {
        Checks.notNull(stream, "InputStream");
        return Icon.from(IOUtil.readFully(stream));
    }

    public static Icon from(byte[] data) {
        Checks.notNull(data, "Provided byte[]");
        try {
            return new Icon(new String(Base64.getEncoder().encode(data), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

