/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.registry;

import net.minecraft.block.Block;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import tinker_io.blocks.FuelInputMachine;
import tinker_io.blocks.OreCrusher;
import tinker_io.blocks.SmartOutput;
import tinker_io.blocks.StirlingEngine;
import tinker_io.blocks.WhatABeautifulBlock;

public class BlockRegistry {
    public static Block fuelInputMachine;
    public static Block smartOutput;
    public static Block whatABeautifulBlock;
    public static Block oreCrusher;
    public static Block stirlingEngine;

    public static void mainRegistry() {
        BlockRegistry.preLoadBlock();
        BlockRegistry.registerBlock();
    }

    private static void preLoadBlock() {
        fuelInputMachine = new FuelInputMachine("fuel_input_machine");
        smartOutput = new SmartOutput("smart_output");
        whatABeautifulBlock = new WhatABeautifulBlock("WhatABeautifulBlock");
        oreCrusher = new OreCrusher("Ore_Crusher");
        stirlingEngine = new StirlingEngine("Stirling_Engine");
    }

    private static void registerBlock() {
        BlockRegistry.registerBlock(fuelInputMachine, "fuel_input_machine");
        BlockRegistry.registerBlock(smartOutput, "smart_output");
        BlockRegistry.registerBlock(whatABeautifulBlock, "WhatABeautifulBlock");
        BlockRegistry.registerBlock(oreCrusher, "Ore_Crusher");
        BlockRegistry.registerBlock(stirlingEngine, "Stirling_Engine");
    }

    public static <K extends IForgeRegistryEntry<?>> K registerBlock(K object, String name) {
        ResourceLocation rsl = new ResourceLocation("tinker_io", name);
        object.setRegistryName(rsl);
        GameRegistry.register(object);
        GameRegistry.register((IForgeRegistryEntry)new ItemBlock((Block)object).setRegistryName(object.getRegistryName()));
        return object;
    }
}

