/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.plugins.jei;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;

public class SmartOutputRecipeWrapper
extends BlankRecipeWrapper {
    protected final List<ItemStack> cast;
    protected final List<FluidStack> inputFluid;
    protected List<ItemStack> output;
    protected boolean isBasin;
    private final CastingRecipe recipe;

    public SmartOutputRecipeWrapper(List<ItemStack> casts, CastingRecipe recipe, boolean isBasin) {
        this.cast = casts;
        this.recipe = recipe;
        this.inputFluid = ImmutableList.of((Object)recipe.getFluid());
        this.output = ImmutableList.of((Object)recipe.getResult());
        this.isBasin = isBasin;
    }

    public SmartOutputRecipeWrapper(CastingRecipe recipe, boolean isBasin) {
        this.isBasin = isBasin;
        this.cast = recipe.cast != null ? recipe.cast.getInputs() : ImmutableList.of();
        this.inputFluid = ImmutableList.of((Object)recipe.getFluid());
        this.recipe = recipe;
        this.output = recipe.getResult() == null ? null : ImmutableList.of((Object)recipe.getResult());
    }

    public boolean hasCast() {
        return this.recipe.cast != null;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, (List)ImmutableList.of(this.cast));
        ingredients.setInputs(FluidStack.class, this.inputFluid);
        ingredients.setOutputs(ItemStack.class, this.hookGetOutputs());
    }

    public List<ItemStack> hookGetOutputs() {
        if (this.output == null) {
            if (this.recipe.getResult() == null) {
                return ImmutableList.of();
            }
            this.output = ImmutableList.of((Object)this.recipe.getResult());
        }
        return this.output;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.recipe.consumesCast()) {
            String s = I18n.func_135052_a((String)"gui.jei.casting.consume", (Object[])new Object[0]);
            int x = 55;
            minecraft.field_71466_p.func_78276_b(s, x -= minecraft.field_71466_p.func_78256_a(s) / 2, 40, 0xAA0000);
        }
    }
}

