/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.plugins.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import tinker_io.registry.ItemRegistry;

public class OreCrusherRecipeWrapper
extends BlankRecipeWrapper {
    protected final List<ItemStack> oreInputList = Lists.newLinkedList();
    protected final List<ItemStack> outputList = Lists.newLinkedList();

    public OreCrusherRecipeWrapper(String oreDic) {
        this.setInputList(oreDic);
        this.setOutputList(oreDic);
    }

    @Deprecated
    public List<ItemStack> getInputs() {
        if (this.oreInputList == null) {
            return this.getInputs();
        }
        return this.oreInputList;
    }

    public List<ItemStack> getOutputsHook() {
        if (this.outputList == null) {
            return ImmutableList.of();
        }
        return this.outputList;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        String s = "45 RF/tick";
        int x = 15;
        minecraft.field_71466_p.func_78276_b(s, x -= minecraft.field_71466_p.func_78256_a(s) / 2, 57, Color.white.getRGB());
    }

    protected void setInputList(String oreDic) {
        List oreList = OreDictionary.getOres((String)oreDic);
        oreList.stream().forEach(ore -> this.oreInputList.add((ItemStack)ore));
    }

    protected void setOutputList(String oreDic) {
        this.outputList.add(this.getProduce(oreDic));
    }

    private ItemStack getProduce(String oreDic) {
        ItemStack produce = new ItemStack(ItemRegistry.CrushedOre, 3);
        produce.func_77982_d(new NBTTagCompound());
        NBTTagCompound nbt = produce.func_77978_p();
        nbt.func_74778_a("oreDic", oreDic);
        return produce;
    }

    public String getOreDicName(ItemStack itemStack) {
        String oreDicName = null;
        if (itemStack != null && OreDictionary.getOreIDs((ItemStack)itemStack).length > 0) {
            int oreID = OreDictionary.getOreIDs((ItemStack)itemStack)[0];
            oreDicName = OreDictionary.getOreName((int)oreID);
        }
        return oreDicName;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, (List)ImmutableList.of(this.oreInputList));
        ingredients.setOutputs(ItemStack.class, this.getOutputsHook());
    }
}

