/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.plugins.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Triple;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import tinker_io.gui.FIMGui;
import tinker_io.gui.OreCrusherGui;
import tinker_io.gui.SOGui;
import tinker_io.handler.OreCrusherRecipe;
import tinker_io.handler.SORecipe;
import tinker_io.plugins.jei.FuelInputMachineRecipeCategory;
import tinker_io.plugins.jei.FuelInputMachineRecipeHandler;
import tinker_io.plugins.jei.FuelInputMachineRecipeWrapper;
import tinker_io.plugins.jei.OreCrusherRecipeCategory;
import tinker_io.plugins.jei.OreCrusherRecipeHandler;
import tinker_io.plugins.jei.OreCrusherRecipeWrapper;
import tinker_io.plugins.jei.SmartOutputRecipeCategory;
import tinker_io.plugins.jei.SmartOutputRecipeHandler;
import tinker_io.plugins.jei.SmartOutputRecipeWrapper;
import tinker_io.registry.BlockRegistry;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;

    public void registerItemSubtypes(ISubtypeRegistry registry) {
    }

    public void register(IModRegistry registry) {
        CastingRecipe recipe;
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        OreCrusherRecipeCategory OCCategory = new OreCrusherRecipeCategory(guiHelper);
        OreCrusherRecipeHandler OCRecipeHandler = new OreCrusherRecipeHandler();
        SmartOutputRecipeCategory SOCategory = new SmartOutputRecipeCategory(guiHelper);
        SmartOutputRecipeHandler SORecipeHandler = new SmartOutputRecipeHandler();
        FuelInputMachineRecipeCategory FIMCategory = new FuelInputMachineRecipeCategory(guiHelper);
        FuelInputMachineRecipeHandler FIMRecipeHandler = new FuelInputMachineRecipeHandler();
        registry.addRecipeCategories(new IRecipeCategory[]{OCCategory, SOCategory, FIMCategory});
        registry.addRecipeHandlers(new IRecipeHandler[]{OCRecipeHandler, SORecipeHandler, FIMRecipeHandler});
        Object[] oreDicArray = OreDictionary.getOreNames();
        ArrayList oreDicList = Lists.newArrayList((Object[])oreDicArray);
        LinkedList FIMrecipeList = Lists.newLinkedList();
        Item.field_150901_e.forEach(item -> {
            ItemStack itemstack = new ItemStack(item);
            if (TileEntityFurnace.func_145954_b((ItemStack)itemstack)) {
                FIMrecipeList.add(new FuelInputMachineRecipeWrapper(itemstack));
            }
        });
        registry.addRecipes((List)FIMrecipeList);
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.fuelInputMachine), new String[]{FIMCategory.getUid()});
        LinkedList OCrecipeList = Lists.newLinkedList();
        oreDicList.stream().forEach(oreDic -> {
            if (OreCrusherRecipe.isOreDicAccepted(oreDic) && OreCrusherRecipe.isOreDicExisted(oreDic)) {
                OCrecipeList.add(new OreCrusherRecipeWrapper((String)oreDic));
            }
        });
        registry.addRecipes((List)OCrecipeList);
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.oreCrusher), new String[]{OCCategory.getUid()});
        HashMap castDict = Maps.newHashMap();
        for (ICastingRecipe irecipe : TinkerRegistry.getAllTableCastingRecipes()) {
            if (!(irecipe instanceof CastingRecipe)) continue;
            recipe = (CastingRecipe)irecipe;
            if (recipe.cast != null && recipe.getResult() != null && recipe.getResult().func_77973_b() instanceof Cast) {
                Triple output = Triple.of((Object)recipe.getResult().func_77973_b(), (Object)Cast.getPartFromTag((ItemStack)recipe.getResult()), (Object)recipe.getFluid().getFluid());
                if (!castDict.containsKey(output)) {
                    LinkedList list = Lists.newLinkedList();
                    castDict.put(output, list);
                    registry.addRecipes((List)ImmutableList.of((Object)((Object)new SmartOutputRecipeWrapper(list, recipe, false))));
                }
                ((List)castDict.get(output)).addAll(recipe.cast.getInputs());
                continue;
            }
            registry.addRecipes((List)ImmutableList.of((Object)((Object)new SmartOutputRecipeWrapper(recipe, false))));
        }
        for (ICastingRecipe irecipe : TinkerRegistry.getAllBasinCastingRecipes()) {
            if (!(irecipe instanceof CastingRecipe)) continue;
            recipe = (CastingRecipe)irecipe;
            registry.addRecipes((List)ImmutableList.of((Object)((Object)new SmartOutputRecipeWrapper(recipe, true))));
        }
        List<CastingRecipe> castingRecipeWithNBT = SORecipe.getCastingRecipeWithNBT();
        castingRecipeWithNBT.stream().forEach(nbtRecipe -> registry.addRecipes((List)ImmutableList.of((Object)((Object)new SmartOutputRecipeWrapper((CastingRecipe)nbtRecipe, false)))));
        registry.addRecipeCategoryCraftingItem(new ItemStack(BlockRegistry.smartOutput), new String[]{SOCategory.getUid()});
        registry.addRecipeClickArea(SOGui.class, 94, 34, 24, 15, new String[]{SmartOutputRecipeCategory.CATEGORY});
        registry.addRecipeClickArea(OreCrusherGui.class, 82, 35, 24, 15, new String[]{OreCrusherRecipeCategory.CATEGORY});
        registry.addRecipeClickArea(FIMGui.class, 102, 35, 18, 18, new String[]{FuelInputMachineRecipeCategory.CATEGORY});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }
}

