/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.handler;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.smeltery.Cast;
import slimeknights.tconstruct.library.smeltery.CastingRecipe;
import slimeknights.tconstruct.library.smeltery.ICastingRecipe;
import slimeknights.tconstruct.smeltery.item.CastCustom;

public class SORecipe {
    private static List<CastingRecipe> tableCastRegistryWithFluidStack = Lists.newLinkedList();

    public ItemStack getCastingRecipes(FluidStack fluid, ItemStack itemStack) {
        ICastingRecipe itableRecipe = TinkerRegistry.getTableCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        CastingRecipe tableRecipeWithFluidStack = SORecipe.getTableCastingWithFluidStack(itemStack, fluid);
        if (itableRecipe != null && itableRecipe instanceof CastingRecipe) {
            CastingRecipe tableRecipe = (CastingRecipe)itableRecipe;
            if (tableRecipe.getResult() != null) {
                return tableRecipe.getResult();
            }
        } else if (tableRecipeWithFluidStack != null) {
            return tableRecipeWithFluidStack.getResult();
        }
        return null;
    }

    public FluidStack getCastingFluidCost(FluidStack fluid, ItemStack itemStack) {
        ICastingRecipe itableRecipe = TinkerRegistry.getTableCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        CastingRecipe tableRecipeWithFluidStack = SORecipe.getTableCastingWithFluidStack(itemStack, fluid);
        CastingRecipe useAbleTableRecipe = null;
        if (itableRecipe != null && itableRecipe instanceof CastingRecipe) {
            CastingRecipe tableRecipe = (CastingRecipe)itableRecipe;
            if (tableRecipe.getResult() != null) {
                useAbleTableRecipe = tableRecipe;
            }
        } else if (tableRecipeWithFluidStack != null) {
            useAbleTableRecipe = tableRecipeWithFluidStack;
        }
        if (useAbleTableRecipe != null) {
            FluidStack tableFluid = useAbleTableRecipe.getFluid();
            if (tableFluid != null) {
                return tableFluid;
            }
            return null;
        }
        return null;
    }

    public boolean isConsumeCast(FluidStack fluid, ItemStack itemStack) {
        ICastingRecipe itableRecipe = TinkerRegistry.getTableCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        CastingRecipe tableRecipeWithFluidStack = SORecipe.getTableCastingWithFluidStack(itemStack, fluid);
        if (itableRecipe != null && itableRecipe instanceof CastingRecipe) {
            CastingRecipe tableRecipe = (CastingRecipe)itableRecipe;
            if (tableRecipe.getResult() != null) {
                return tableRecipe.consumesCast();
            }
        } else if (tableRecipeWithFluidStack != null) {
            return tableRecipeWithFluidStack.consumesCast();
        }
        return false;
    }

    public boolean isPattern(ItemStack output) {
        Collection items = TinkerRegistry.getPatternItems();
        Item item = output.func_77973_b();
        for (Item i : items) {
            if (!item.equals(i)) continue;
            return true;
        }
        return output.func_77973_b() instanceof CastCustom || output.func_77973_b() instanceof Cast;
    }

    public FluidStack getBasinFluidCost(FluidStack fluid, ItemStack itemStack) {
        ICastingRecipe ibasinRecipe = TinkerRegistry.getBasinCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        if (ibasinRecipe != null && ibasinRecipe instanceof CastingRecipe) {
            CastingRecipe basinRecipe = (CastingRecipe)ibasinRecipe;
            FluidStack basinFluid = basinRecipe.getFluid();
            if (basinFluid != null) {
                return basinFluid;
            }
            return null;
        }
        return null;
    }

    public ItemStack getBasinResult(FluidStack fluid, ItemStack itemStack) {
        ICastingRecipe ibasinRecipe = TinkerRegistry.getBasinCasting((ItemStack)itemStack, (Fluid)fluid.getFluid());
        if (ibasinRecipe != null && ibasinRecipe instanceof CastingRecipe) {
            CastingRecipe basinRecipe = (CastingRecipe)ibasinRecipe;
            ItemStack basinResult = basinRecipe.getResult();
            return basinResult;
        }
        return null;
    }

    public static void registerTableCastingWithFluidStack(CastingRecipe recipe) {
        tableCastRegistryWithFluidStack.add(recipe);
    }

    public static CastingRecipe getTableCastingWithFluidStack(ItemStack cast, FluidStack fluidstack) {
        for (CastingRecipe recipe : tableCastRegistryWithFluidStack) {
            if (!SORecipe.matches(cast, fluidstack, recipe)) continue;
            return recipe;
        }
        return null;
    }

    public static boolean matches(ItemStack cast, FluidStack fluidStack, CastingRecipe recipe) {
        if (cast == null && recipe.cast == null || recipe.cast != null && recipe.cast.matches(new ItemStack[]{cast}) != null) {
            return recipe.getFluid().isFluidEqual(fluidStack);
        }
        return false;
    }

    public static List<CastingRecipe> getCastingRecipeWithNBT() {
        return tableCastRegistryWithFluidStack;
    }
}

