/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.handler;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import slimeknights.mantle.util.RecipeMatch;
import tinker_io.fluids.PureMetal;
import tinker_io.handler.OreCrusherRecipe;
import tinker_io.main.Main;
import tinker_io.registry.FluidRegister;
import tinker_io.registry.ItemRegistry;
import tinker_io.registry.SmelteryRecipeRegistry;

public class CrushedOreMeltingRegistry {
    public static void registerCrushedOre() {
        String[] oreDicts = OreDictionary.getOreNames();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < oreDicts.length; ++i) {
            if (!OreCrusherRecipe.isOreDicAccepted(oreDicts[i])) continue;
            PureMetal pureMetal = FluidRegister.pureMetal;
            FluidStack pureMetalStack = new FluidStack((Fluid)pureMetal, 144);
            ItemStack crushedOreStack = new ItemStack(ItemRegistry.CrushedOre);
            crushedOreStack.func_77982_d(new NBTTagCompound());
            crushedOreStack.func_77978_p().func_74778_a("oreDic", oreDicts[i]);
            SmelteryRecipeRegistry.registerMeltingWithNBT(crushedOreStack, CrushedOreMeltingRegistry.itemNBTtoFluidNBT(pureMetalStack, crushedOreStack), 350);
        }
        long endTime = System.currentTimeMillis();
        long totalTime = endTime - startTime;
        Main.logger.log(Level.INFO, "Crushed Ore melting registry loaded. Cost " + totalTime + " ms");
    }

    private static FluidStack itemNBTtoFluidNBT(FluidStack fluidStack, ItemStack itemStack) {
        NBTTagCompound fluidNBT = new NBTTagCompound();
        NBTTagCompound itemNBT = null;
        ItemStack itemInputStack = null;
        RecipeMatch.ItemCombination itemCombination = new RecipeMatch.ItemCombination(1, new ItemStack[]{itemStack});
        List itemInput = itemCombination.getInputs();
        if (!itemInput.isEmpty()) {
            itemInputStack = (ItemStack)itemInput.get(0);
            itemNBT = itemInputStack.func_77978_p();
        }
        if (itemNBT != null) {
            fluidNBT = itemNBT.func_74737_b();
            fluidStack = new FluidStack(fluidStack.getFluid(), fluidStack.amount, fluidNBT);
        }
        return fluidStack;
    }
}

