/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.fluids;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import tinker_io.handler.CrushedOreColorList;

public class PureMetal
extends Fluid {
    private static String tinkersDomain = "tconstruct:";

    public PureMetal(String fluidName) {
        super(fluidName, new ResourceLocation(tinkersDomain + "blocks/fluids/molten_metal"), new ResourceLocation(tinkersDomain + "blocks/fluids/molten_metal_flow"));
        this.setLuminosity(10).setDensity(1600).setViscosity(1500).setTemperature(600);
    }

    public int getColor(FluidStack stack) {
        CrushedOreColorList colorList = new CrushedOreColorList();
        return colorList.getColor(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public String getLocalizedName(FluidStack stack) {
        String oreDicName;
        List oreList;
        String s = this.getUnlocalizedName();
        String name = s == null ? "" : I18n.func_74838_a((String)s);
        NBTTagCompound nbt = stack.tag;
        if (nbt != null && !(oreList = OreDictionary.getOres((String)(oreDicName = nbt.func_74779_i("oreDic")))).isEmpty()) {
            ItemStack oreItem = (ItemStack)oreList.get(0);
            String oreName = oreItem.func_82833_r();
            name = name + " (" + oreName + ")";
        }
        return name;
    }
}

