/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.blocks;

import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import tinker_io.TileEntity.OreCrusherTileEntity;
import tinker_io.blocks.BlockContainerAdapter;
import tinker_io.main.Main;

public class OreCrusher
extends BlockContainerAdapter {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public OreCrusher(String unlocalizedName) {
        this.func_149663_c(unlocalizedName);
        this.func_149647_a(Main.TinkerIOTabs);
        this.setHarvestLevel("pickaxe", 1);
        this.func_149711_c(3.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new OreCrusherTileEntity();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public boolean func_189539_a(IBlockState state, World worldIn, BlockPos pos, int id, int param) {
        super.func_189539_a(state, worldIn, pos, id, param);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        if (!worldIn.field_72995_K) {
            playerIn.openGui((Object)Main.instance, 2, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(worldIn, pos, state);
    }

    private void setDefaultFacing(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            Block block = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
            Block block1 = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
            Block block2 = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
            Block block3 = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (enumfacing == EnumFacing.NORTH && block.func_149730_j(state) && !block1.func_149730_j(state)) {
                enumfacing = EnumFacing.SOUTH;
            } else if (enumfacing == EnumFacing.SOUTH && block1.func_149730_j(state) && !block.func_149730_j(state)) {
                enumfacing = EnumFacing.NORTH;
            } else if (enumfacing == EnumFacing.WEST && block2.func_149730_j(state) && !block3.func_149730_j(state)) {
                enumfacing = EnumFacing.EAST;
            } else if (enumfacing == EnumFacing.EAST && block3.func_149730_j(state) && !block2.func_149730_j(state)) {
                enumfacing = EnumFacing.WEST;
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)enumfacing), 2);
        }
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        TileEntity te = worldIn.func_175625_s(pos);
        if (te != null) {
            OreCrusherTileEntity engine = (OreCrusherTileEntity)te;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                engine.getStorage().setEnergyStored(nbt.func_74762_e("energy"));
            }
        }
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return false;
        }
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), null);
        }
        world.func_175698_g(pos);
        return false;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List items = super.getDrops(world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof OreCrusherTileEntity) {
            OreCrusherTileEntity engine = (OreCrusherTileEntity)te;
            for (ItemStack item : items) {
                if (item.func_77973_b() != Item.func_150898_a((Block)this)) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("energy", engine.getStorage().getEnergyStored());
                item.func_77982_d(tag);
            }
        }
        return items;
    }
}

