/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity.fim;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ITickable;
import tinker_io.TileEntity.fim.FIMTileEntity;
import tinker_io.TileEntity.fim.NBTable;
import tinker_io.TileEntity.fim.Process;
import tinker_io.TileEntity.fim.ProcessSpeedUp;
import tinker_io.TileEntity.fim.ProcessWaitFuel;
import tinker_io.config.TIOConfig;

public class FuelFSM
implements ITickable,
NBTable {
    public final Process speedup = new ProcessSpeedUp();
    public final Process waitFuel = new ProcessWaitFuel();
    private Process currentState;
    public boolean isActive = false;
    public boolean canChangeState = false;
    FIMTileEntity tile;

    public FuelFSM(FIMTileEntity tile) {
        this.tile = tile;
    }

    public void init() {
        this.currentState = this.isActive ? this.speedup : this.waitFuel;
    }

    public void func_73660_a() {
        this.currentState.accept(this);
    }

    public boolean isSpeedingUp() {
        return this.tile.inputTime > 0;
    }

    public int computeFuelTemp() {
        ItemStack stack = this.tile.getSlot(1);
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public int computeInputTime() {
        return TIOConfig.fuelConsumptionRateFIM;
    }

    public int getFuelStackSize() {
        ItemStack stack = this.tile.getSlot(1);
        return FuelFSM.getStackSize(stack);
    }

    public static int getStackSize(ItemStack stack) {
        return stack == null ? 0 : stack.field_77994_a;
    }

    public void setProcess(Process state) {
        this.currentState = state;
    }

    public void startChangeState() {
        this.canChangeState = true;
    }

    void heat() {
        this.isActive = true;
        this.tile.inputTime -= 4;
    }

    @Override
    public NBTTagCompound readFromNBT(NBTTagCompound tag) {
        this.isActive = tag.func_74767_n("isActive");
        return tag;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("isActive", this.isActive);
        return tag;
    }
}

