/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.fluid.FluidTankAnimated;
import slimeknights.tconstruct.smeltery.tileentity.TileTank;
import tinker_io.api.BlockFinder;

public class StirlingEngineTileEntity
extends TileEntity
implements ITickable,
IEnergyProvider {
    public double angel;
    protected EnergyStorage storage = new EnergyStorage(500000, 0, 2000);
    protected int generatePerTick;
    private int extraEnergyID;

    private void generateEnergy() {
        BlockPos tankPos = this.field_174879_c.func_177977_b();
        int fluidTemp = 0;
        int generateEnergy = 0;
        TileEntity te = this.field_145850_b.func_175625_s(tankPos);
        if (te instanceof TileTank) {
            TileTank teTank = (TileTank)this.field_145850_b.func_175625_s(tankPos);
            if (teTank != null) {
                FluidTankAnimated toDrain = teTank.getInternalTank();
                FluidStack canDrain = toDrain.drain(1, false);
                FluidStack fulid = teTank.getInternalTank().getFluid();
                if (fulid != null && this.getEnergyStored(null) < this.storage.getMaxEnergyStored()) {
                    fluidTemp = fulid.getFluid().getTemperature();
                    generateEnergy = (fluidTemp -= 300) * 15 / 100;
                    if (generateEnergy > 0) {
                        this.generatePerTick = generateEnergy;
                        this.storage.setEnergyStored(this.storage.getEnergyStored() + generateEnergy);
                        if (canDrain != null) {
                            toDrain.drain(2, true);
                        }
                    }
                } else {
                    this.generatePerTick = 0;
                }
            } else {
                this.generatePerTick = 0;
            }
        }
    }

    public int getGeneratePetTick() {
        return this.generatePerTick;
    }

    private void angel() {
        FluidStack fulid;
        TileTank teTank;
        BlockPos tankPos = new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p());
        int fluidTemp = 0;
        double anglePlus = 0.0;
        TileEntity te = this.field_145850_b.func_175625_s(tankPos);
        if (te instanceof TileTank && (teTank = (TileTank)this.field_145850_b.func_175625_s(tankPos)) != null && (fulid = teTank.getInternalTank().getFluid()) != null) {
            fluidTemp = fulid.getFluid().getTemperature();
        }
        if (fluidTemp - 300 > 0 && this.getEnergyStored(null) < this.storage.getMaxEnergyStored()) {
            anglePlus = 1.0;
        }
        this.angel = this.angel <= 60.0 ? (this.angel += anglePlus) : 0.0;
    }

    private void extraEnergyToSurroundingMechine() {
        BlockPos blockPos;
        int extraPerTick = Math.min(this.storage.getEnergyStored(), 1000);
        BlockFinder blockFinder = new BlockFinder(this.field_174879_c, this.field_145850_b);
        List<Object> blocPoskList = blockFinder.getSurroundingTileEntityPos(this.field_174879_c);
        if ((blocPoskList = blocPoskList.stream().filter(pos -> this.field_145850_b.func_175625_s(pos) instanceof IEnergyReceiver).collect(Collectors.toList())).size() == 0) {
            return;
        }
        if (this.extraEnergyID >= blocPoskList.size()) {
            this.extraEnergyID = 0;
        }
        if ((blockPos = (BlockPos)blocPoskList.get(this.extraEnergyID)) == null) {
            this.extraEnergyID = 0;
            return;
        }
        int averageExtraEnergy = (int)Math.floor(extraPerTick / blocPoskList.size());
        IEnergyReceiver rfStorage = (IEnergyReceiver)this.field_145850_b.func_175625_s(blockPos);
        if (rfStorage != null && this.storage.getEnergyStored() > 0 && rfStorage.getEnergyStored(EnumFacing.DOWN) < rfStorage.getMaxEnergyStored(EnumFacing.DOWN)) {
            this.storage.setEnergyStored(this.storage.getEnergyStored() - averageExtraEnergy);
            rfStorage.receiveEnergy(EnumFacing.DOWN, averageExtraEnergy, false);
        }
        ++this.extraEnergyID;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.angel();
        this.notifyBlockUpdate();
        this.generateEnergy();
        this.extraEnergyToSurroundingMechine();
    }

    public TileTank getTETank() {
        TileTank teTank;
        BlockPos tankPos = new BlockPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o() - 1, this.field_174879_c.func_177952_p());
        TileEntity teUnknow = this.field_145850_b.func_175625_s(tankPos);
        if (teUnknow instanceof TileTank && (teTank = (TileTank)this.field_145850_b.func_175625_s(tankPos)) != null) {
            return teTank;
        }
        return null;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.angel = tagCompound.func_74769_h("Angel");
        this.generatePerTick = tagCompound.func_74762_e("generatePerTick");
        this.storage.readFromNBT(tagCompound);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74780_a("Angel", (double)((short)this.angel));
        tagCompound.func_74768_a("generatePerTick", this.generatePerTick);
        this.storage.writeToNBT(tagCompound);
        return tagCompound;
    }

    @Override
    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    @Override
    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(Math.min(this.storage.getMaxExtract(), maxExtract), simulate);
    }

    public EnergyStorage getStorage() {
        return this.storage;
    }

    private void notifyBlockUpdate() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }
}

