/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.TileEntity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.multiblock.MultiServantLogic;
import tinker_io.handler.SORecipe;
import tinker_io.registry.ItemRegistry;

public class SOTileEntity
extends MultiServantLogic
implements IFluidHandler,
IFluidTank,
ISidedInventory,
ITickable {
    public FluidTank tank;
    public FluidStack otherLiquid;
    public FluidTankInfo[] otherTankInfo = null;
    public ItemStack[] itemStacksSO = new ItemStack[4];
    private final int[] slotsPattern = new int[]{0};
    private final int[] slotsProduct = new int[]{1};
    private final int[] slotsUPGup = new int[]{2};
    private final int[] slotsUPGdown = new int[]{3};
    int connection = 0;
    int tick = 0;
    public int currentFrozenTime = 0;
    public int frozenTimeMax = 2;
    SORecipe recipes = new SORecipe();
    private String nameSO;

    public SOTileEntity() {
        this.tank = new FluidTank(10000);
    }

    public int fill(FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        this.notifyBlockUpdate();
        return amount;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.tank.getFluidAmount() == 0) {
            return null;
        }
        if (this.tank.getFluid().getFluid() != resource.getFluid()) {
            return null;
        }
        this.notifyBlockUpdate();
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        FluidStack amount = this.tank.drain(maxDrain, doDrain);
        if (amount != null && doDrain) {
            this.notifyBlockUpdate();
        }
        return amount;
    }

    public FluidTankInfo getInfo() {
        return this.tank.getInfo();
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.tank.getTankProperties();
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getFluidAmount() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().amount;
        }
        return 0;
    }

    public int getCapacity() {
        return this.tank.getCapacity();
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.tank;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_145839_a(NBTTagCompound tags) {
        super.func_145839_a(tags);
        this.readCustomNBT(tags);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tags) {
        super.func_189515_b(tags);
        this.writeCustomNBT(tags);
        return tags;
    }

    public void readCustomNBT(NBTTagCompound tags) {
        this.currentFrozenTime = tags.func_74762_e("CurrentFrozenTime");
        if (tags.func_74767_n("hasFluid")) {
            if (tags.func_74762_e("itemID") == 0) {
                FluidStack tankFluid = FluidRegistry.getFluidStack((String)tags.func_74779_i("fluidName"), (int)tags.func_74762_e("amount"));
                if (tags.func_74779_i("fluidTag") != null) {
                    tankFluid = new FluidStack(tankFluid.getFluid(), tankFluid.amount, (NBTTagCompound)tags.func_74781_a("fluidTag"));
                }
                this.tank.setFluid(tankFluid);
            }
        } else {
            this.tank.setFluid(null);
        }
        NBTTagList tagList = tags.func_150295_c("Items", 10);
        this.itemStacksSO = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tabCompound1 = tagList.func_150305_b(i);
            byte byte0 = tabCompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.itemStacksSO.length) continue;
            this.itemStacksSO[byte0] = ItemStack.func_77949_a((NBTTagCompound)tabCompound1);
        }
    }

    public NBTTagCompound writeCustomNBT(NBTTagCompound tags) {
        tags.func_74768_a("CurrentFrozenTime", this.currentFrozenTime);
        FluidStack liquid = this.tank.getFluid();
        tags.func_74757_a("hasFluid", liquid != null);
        if (liquid != null) {
            tags.func_74778_a("fluidName", liquid.getFluid().getName());
            tags.func_74768_a("amount", liquid.amount);
            if (this.tank.getFluid() != null && this.tank.getFluid().tag != null) {
                tags.func_74782_a("fluidTag", (NBTBase)this.tank.getFluid().tag);
            }
        }
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.itemStacksSO.length; ++i) {
            if (this.itemStacksSO[i] == null) continue;
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            this.itemStacksSO[i].func_77955_b(tagCompound);
            tagList.func_74742_a((NBTBase)tagCompound);
        }
        tags.func_74782_a("Items", (NBTBase)tagList);
        return tags;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.itemStacksSO.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.itemStacksSO[slot];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.itemStacksSO[par1] != null) {
            if (this.itemStacksSO[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.itemStacksSO[par1];
                this.itemStacksSO[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.itemStacksSO[par1].func_77979_a(par2);
            if (this.itemStacksSO[par1].field_77994_a == 0) {
                this.itemStacksSO[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.itemStacksSO[slot] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }

    public int getLiquidAmount(int par1) {
        FluidTankInfo info = this.getInfo();
        FluidStack liquid = info.fluid;
        int capacity = 0;
        int liquidAmount = 0;
        int bar = 0;
        if (liquid != null && info != null) {
            liquidAmount = liquid.amount;
            capacity = info.capacity;
        } else {
            liquidAmount = 0;
            capacity = 0;
        }
        bar = liquidAmount != 0 && capacity != 0 ? (int)Math.floor((double)liquidAmount / (double)capacity * (double)par1) : 0;
        return bar;
    }

    public int getOutputSize() {
        int size = 1;
        ItemStack slotUPG1 = new ItemStack(ItemRegistry.Upgrade, 1, 1);
        ItemStack slotUPG2 = new ItemStack(ItemRegistry.Upgrade, 1, 2);
        ItemStack slotUPG3 = new ItemStack(ItemRegistry.Upgrade, 1, 3);
        ItemStack slotUPG4 = new ItemStack(ItemRegistry.Upgrade, 1, 4);
        if (this.itemStacksSO[2] != null) {
            if (this.itemStacksSO[2].func_77969_a(slotUPG1)) {
                size += this.itemStacksSO[2].field_77994_a * 1;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG2)) {
                size += this.itemStacksSO[2].field_77994_a * 2;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG3)) {
                size += this.itemStacksSO[2].field_77994_a * 3;
            } else if (this.itemStacksSO[2].func_77969_a(slotUPG4)) {
                size += this.itemStacksSO[2].field_77994_a * 4;
            }
        }
        if (this.itemStacksSO[3] != null) {
            if (this.itemStacksSO[3].func_77969_a(slotUPG1)) {
                size += this.itemStacksSO[3].field_77994_a * 1;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG2)) {
                size += this.itemStacksSO[3].field_77994_a * 2;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG3)) {
                size += this.itemStacksSO[3].field_77994_a * 3;
            } else if (this.itemStacksSO[3].func_77969_a(slotUPG4)) {
                size += this.itemStacksSO[3].field_77994_a * 4;
            }
        }
        if (size > 64) {
            return 64;
        }
        return size;
    }

    public boolean hasRedstoneUPG() {
        ItemStack redStoneUPG = new ItemStack(ItemRegistry.Upgrade, 1, 5);
        if (this.itemStacksSO[2] != null && this.itemStacksSO[2].func_77969_a(redStoneUPG)) {
            return true;
        }
        return this.itemStacksSO[3] != null && this.itemStacksSO[3].func_77969_a(redStoneUPG);
    }

    public boolean hasBasinUPG() {
        ItemStack basinUPG = new ItemStack(ItemRegistry.Upgrade, 1, 7);
        if (this.itemStacksSO[2] != null && this.itemStacksSO[2].func_77969_a(basinUPG)) {
            return true;
        }
        return this.itemStacksSO[3] != null && this.itemStacksSO[3].func_77969_a(basinUPG);
    }

    public String getMode() {
        String mode = null;
        FluidTankInfo info = this.getInfo();
        FluidStack liquid = info.fluid;
        ItemStack resultItem = null;
        if (info != null && liquid != null) {
            if (this.hasBasinUPG()) {
                if (this.recipes.getBasinFluidCost(liquid, this.itemStacksSO[0]) != null && this.recipes.getBasinFluidCost((FluidStack)liquid, (ItemStack)this.itemStacksSO[0]).amount <= liquid.amount && this.recipes.getBasinResult(liquid, this.itemStacksSO[0]) != null) {
                    resultItem = this.recipes.getBasinResult(liquid, this.itemStacksSO[0]);
                    mode = "basin";
                }
            } else if (this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]) != null && this.recipes.getCastingFluidCost((FluidStack)liquid, (ItemStack)this.itemStacksSO[0]).amount <= liquid.amount && this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]) != null) {
                resultItem = this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]);
                mode = "table";
            }
            if (this.itemStacksSO[1] != null && resultItem != null) {
                int resultSize = this.itemStacksSO[1].field_77994_a + resultItem.field_77994_a;
                mode = resultSize <= this.getOutputSize() && resultSize <= this.func_70297_j_() && resultSize <= this.itemStacksSO[1].func_77976_d() && this.itemStacksSO[1].func_77969_a(resultItem) ? mode : null;
            }
        }
        return mode;
    }

    public boolean canFrozen() {
        boolean hasPowered = this.field_145850_b.func_175640_z(this.field_174879_c);
        boolean canStart = false;
        canStart = this.hasRedstoneUPG() ? !hasPowered : true;
        return canStart && this.getMode() != null;
    }

    public void frozen() {
        FluidTankInfo info = this.getInfo();
        FluidStack liquid = info.fluid;
        ItemStack product = null;
        FluidStack fluidCost = null;
        String mode = this.getMode();
        if (this.canFrozen() && info != null && mode.equals("table")) {
            product = this.recipes.getCastingRecipes(liquid, this.itemStacksSO[0]);
            fluidCost = this.recipes.getCastingFluidCost(liquid, this.itemStacksSO[0]);
        } else if (this.canFrozen() && info != null && mode.equals("basin")) {
            product = this.recipes.getBasinResult(liquid, this.itemStacksSO[0]);
            fluidCost = this.recipes.getBasinFluidCost(liquid, this.itemStacksSO[0]);
        }
        if (product != null && fluidCost != null && fluidCost.amount <= liquid.amount) {
            this.drain(fluidCost, true);
            if (this.itemStacksSO[1] == null) {
                this.itemStacksSO[1] = product.func_77946_l();
            } else if (this.itemStacksSO[1].func_77973_b() == product.func_77973_b()) {
                this.itemStacksSO[1].field_77994_a += product.field_77994_a;
            }
            if (this.itemStacksSO[0] != null && (mode.equals("basin") || this.recipes.isConsumeCast(liquid, this.itemStacksSO[0]))) {
                if (this.itemStacksSO[0].field_77994_a == 1) {
                    this.itemStacksSO[0] = null;
                } else {
                    --this.itemStacksSO[0].field_77994_a;
                }
            }
        }
    }

    public void voidLiquid() {
        FluidTankInfo info = this.getInfo();
        FluidStack liquid = info.fluid;
        if (liquid != null) {
            int amount = liquid.amount;
            int toVoid = this.tank.drain((int)amount, (boolean)false).amount;
            this.tank.drain(toVoid, true);
            this.notifyBlockUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getFrozenProgressScaled(int par1) {
        return this.currentFrozenTime * par1 / this.frozenTimeMax;
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canFrozen()) {
            if (this.currentFrozenTime >= this.frozenTimeMax) {
                this.currentFrozenTime = 0;
                this.frozen();
            } else {
                ++this.currentFrozenTime;
            }
            this.notifyBlockUpdate();
        }
        if (this.tank.canFill() || this.tank.canDrain()) {
            if (this.tick % 4 == 0) {
                this.notifyBlockUpdate();
                this.tick = 0;
            }
            ++this.tick;
        }
    }

    public ItemStack func_70304_b(int index) {
        if (this.itemStacksSO[index] != null) {
            ItemStack itemstack = this.itemStacksSO[index];
            this.itemStacksSO[index] = null;
            return itemstack;
        }
        return null;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.nameSO : I18n.func_135052_a((String)"tile.smart_output.name", (Object[])new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.nameSO != null && this.nameSO.length() > 0;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public int[] func_180463_a(EnumFacing side) {
        return this.slotsProduct;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return stack != null;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    private void notifyBlockUpdate() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }
}

