/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import noppes.npcs.NBTTags;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.roles.JobInterface;
import noppes.npcs.util.ValueUtil;

public class JobHealer
extends JobInterface {
    private int healTicks = 0;
    public int range = 8;
    public byte type = (byte)2;
    public int speed = 20;
    public HashMap<Integer, Integer> effects = new HashMap();
    private List<EntityLivingBase> affected = new ArrayList<EntityLivingBase>();

    public JobHealer(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("HealerRange", this.range);
        nbttagcompound.func_74774_a("HealerType", this.type);
        nbttagcompound.func_74782_a("BeaconEffects", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.effects));
        nbttagcompound.func_74768_a("HealerSpeed", this.speed);
        return nbttagcompound;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.range = nbttagcompound.func_74762_e("HealerRange");
        this.type = nbttagcompound.func_74771_c("HealerType");
        this.effects = NBTTags.getIntegerIntegerMap(nbttagcompound.func_150295_c("BeaconEffects", 10));
        this.speed = ValueUtil.CorrectInt(nbttagcompound.func_74762_e("HealerSpeed"), 10, Integer.MAX_VALUE);
    }

    @Override
    public boolean aiShouldExecute() {
        ++this.healTicks;
        if (this.healTicks < this.speed) {
            return false;
        }
        this.healTicks = 0;
        this.affected = this.npc.field_70170_p.func_72872_a(EntityLivingBase.class, this.npc.func_174813_aQ().func_72321_a((double)this.range, (double)this.range / 2.0, (double)this.range));
        return !this.affected.isEmpty();
    }

    @Override
    public boolean aiContinueExecute() {
        return false;
    }

    @Override
    public void aiStartExecuting() {
        for (EntityLivingBase entity : this.affected) {
            boolean isEnemy = false;
            isEnemy = entity instanceof EntityPlayer ? this.npc.faction.isAggressiveToPlayer((EntityPlayer)entity) : (entity instanceof EntityNPCInterface ? this.npc.faction.isAggressiveToNpc((EntityNPCInterface)entity) : entity instanceof EntityMob);
            if (entity == this.npc || this.type == 0 && isEnemy || this.type == 1 && !isEnemy) continue;
            for (Integer potionEffect : this.effects.keySet()) {
                Potion p = Potion.func_188412_a((int)potionEffect);
                if (p == null) continue;
                entity.func_70690_d(new PotionEffect(p, 100, this.effects.get(potionEffect).intValue()));
            }
        }
        this.affected.clear();
    }
}

