/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumHand;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.EventHooks;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.event.PlayerEvent;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerScriptData;
import noppes.npcs.entity.EntityNPCInterface;

public class ScriptPlayerEventHandler {
    @SubscribeEvent
    public void onServerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.START) {
            PlayerData data = PlayerData.get(event.player);
            if (event.player.field_70173_aa % 10 == 0) {
                EventHooks.onPlayerTick(data.scriptData);
            }
            data.timers.update();
        }
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K || event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 2, NpcAPI.Instance().getIBlock(event.getWorld(), event.getPos()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.EntityInteract event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K || event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 1, NpcAPI.Instance().getIEntity(event.getTarget()));
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
    }

    @SubscribeEvent
    public void invoke(PlayerInteractEvent.RightClickItem event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K || event.getHand() != EnumHand.MAIN_HAND) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        PlayerEvent.InteractEvent ev = new PlayerEvent.InteractEvent(handler.getPlayer(), 0, null);
        event.setCanceled(EventHooks.onPlayerInteract(handler, ev));
    }

    @SubscribeEvent
    public void invoke(ArrowLooseEvent event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        PlayerEvent.RangedLaunchedEvent ev = new PlayerEvent.RangedLaunchedEvent(handler.getPlayer());
        event.setCanceled(EventHooks.onPlayerRanged(handler, ev));
    }

    @SubscribeEvent
    public void invoke(BlockEvent.BreakEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getPlayer()).scriptData;
        PlayerEvent.BreakEvent ev = new PlayerEvent.BreakEvent(handler.getPlayer(), NpcAPI.Instance().getIBlock(event.getWorld(), event.getPos()), event.getExpToDrop());
        event.setCanceled(EventHooks.onPlayerBreak(handler, ev));
        event.setExpToDrop(ev.exp);
    }

    @SubscribeEvent
    public void invoke(ItemTossEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getPlayer()).scriptData;
        event.setCanceled(EventHooks.onPlayerToss(handler, event.getEntityItem()));
    }

    @SubscribeEvent
    public void invoke(PlayerContainerEvent.Open event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        EventHooks.onPlayerContainerOpen(handler, event.getContainer());
    }

    @SubscribeEvent
    public void invoke(PlayerContainerEvent.Close event) {
        if (event.getEntityPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getEntityPlayer()).scriptData;
        EventHooks.onPlayerContainerClose(handler, event.getContainer());
    }

    @SubscribeEvent
    public void invoke(LivingDeathEvent event) {
        PlayerScriptData handler;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (event.getEntityLiving() instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)event.getEntityLiving())).scriptData;
            EventHooks.onPlayerDeath(handler, event.getSource(), source);
        }
        if (source instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)source)).scriptData;
            EventHooks.onPlayerKills(handler, event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void invoke(LivingHurtEvent event) {
        PlayerEvent pevent;
        PlayerScriptData handler;
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        Entity source = NoppesUtilServer.GetDamageSourcee(event.getSource());
        if (event.getEntityLiving() instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)event.getEntityLiving())).scriptData;
            pevent = new PlayerEvent.DamagedEvent(handler.getPlayer(), source, event.getAmount(), event.getSource());
            event.setCanceled(EventHooks.onPlayerDamaged(handler, pevent));
            event.setAmount(pevent.damage);
        }
        if (source instanceof EntityPlayer) {
            handler = PlayerData.get((EntityPlayer)((EntityPlayer)source)).scriptData;
            pevent = new PlayerEvent.DamagedEntityEvent(handler.getPlayer(), source, event.getAmount(), event.getSource());
            event.setCanceled(EventHooks.onPlayerDamagedEntity(handler, (PlayerEvent.DamagedEntityEvent)pevent));
            event.setAmount(((PlayerEvent.DamagedEntityEvent)pevent).damage);
        }
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.player).scriptData;
        EventHooks.onPlayerLogin(handler);
    }

    @SubscribeEvent
    public void invoke(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.player).scriptData;
        EventHooks.onPlayerLogout(handler);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void invoke(ServerChatEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K || event.getPlayer() == EntityNPCInterface.ChatEventPlayer) {
            return;
        }
        PlayerScriptData handler = PlayerData.get((EntityPlayer)event.getPlayer()).scriptData;
        PlayerEvent.ChatEvent ev = new PlayerEvent.ChatEvent(handler.getPlayer(), event.getMessage());
        EventHooks.onPlayerChat(handler, ev);
        event.setCanceled(ev.isCanceled());
        if (event.isCanceled()) {
            event.setComponent(ForgeHooks.newChatWithLinks((String)ev.message));
        }
    }
}

