/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiAchievement;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.stats.Achievement;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelData;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.PacketHandlerServer;
import noppes.npcs.Server;
import noppes.npcs.ServerEventsHandler;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.client.ClientProxy;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.QuestAchievement;
import noppes.npcs.client.RenderChatMessages;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.client.gui.GuiNpcMobSpawnerAdd;
import noppes.npcs.client.gui.player.GuiQuestCompletion;
import noppes.npcs.client.gui.util.GuiContainerNPCInterface;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IGuiClose;
import noppes.npcs.client.gui.util.IGuiData;
import noppes.npcs.client.gui.util.IGuiError;
import noppes.npcs.client.gui.util.IScrollData;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.controllers.DialogController;
import noppes.npcs.controllers.QuestController;
import noppes.npcs.controllers.SyncController;
import noppes.npcs.controllers.data.Dialog;
import noppes.npcs.controllers.data.MarkData;
import noppes.npcs.entity.EntityCustomNpc;
import noppes.npcs.entity.EntityDialogNpc;
import noppes.npcs.entity.EntityNPCInterface;

public class PacketHandlerClient
extends PacketHandlerServer {
    @SubscribeEvent
    public void onPacketData(FMLNetworkEvent.ClientCustomPacketEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        final ByteBuf buffer = event.getPacket().payload();
        Minecraft.func_71410_x().func_152344_a(new Runnable((EntityPlayer)player){
            final /* synthetic */ EntityPlayer val$player;
            {
                this.val$player = entityPlayer;
            }

            @Override
            public void run() {
                EnumPacketClient en = null;
                try {
                    en = EnumPacketClient.values()[buffer.readInt()];
                    PacketHandlerClient.this.client(buffer, this.val$player, en);
                }
                catch (Exception e) {
                    LogWriter.error("Error with EnumPacketClient." + (Object)((Object)en), e);
                }
            }
        });
    }

    private void client(ByteBuf buffer, final EntityPlayer player, EnumPacketClient type) throws Exception {
        int config;
        if (type == EnumPacketClient.CHATBUBBLE) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            EntityNPCInterface npc = (EntityNPCInterface)entity;
            if (npc.messages == null) {
                npc.messages = new RenderChatMessages();
            }
            String text = NoppesStringUtils.formatText(Server.readString(buffer), new Object[]{player, npc});
            npc.messages.addMessage(text, npc);
            if (buffer.readBoolean()) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation(npc.func_70005_c_() + ": " + text, new Object[0]));
            }
        } else if (type == EnumPacketClient.CHAT) {
            String str;
            String message = "";
            while ((str = Server.readString(buffer)) != null && !str.isEmpty()) {
                message = message + I18n.func_74838_a((String)str);
            }
            player.func_145747_a((ITextComponent)new TextComponentTranslation(message, new Object[0]));
        } else if (type == EnumPacketClient.EYE_BLINK) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ModelData data = ((EntityCustomNpc)entity).modelData;
            data.eyes.blinkStart = System.currentTimeMillis();
        } else if (type == EnumPacketClient.MESSAGE) {
            String description = I18n.func_74838_a((String)Server.readString(buffer));
            String message = Server.readString(buffer);
            QuestAchievement ach = new QuestAchievement(message, description);
            Minecraft.func_71410_x().field_71458_u.func_146256_a((Achievement)ach);
            ObfuscationReflectionHelper.setPrivateValue(GuiAchievement.class, (Object)Minecraft.func_71410_x().field_71458_u, (Object)ach.func_75989_e(), (int)4);
            ObfuscationReflectionHelper.setPrivateValue(GuiAchievement.class, (Object)Minecraft.func_71410_x().field_71458_u, (Object)message, (int)5);
        } else if (type == EnumPacketClient.SYNC_ADD || type == EnumPacketClient.SYNC_END) {
            int synctype = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            SyncController.clientSync(synctype, compound, type == EnumPacketClient.SYNC_END);
            if (synctype == 8) {
                ClientProxy.playerData.setNBT(compound);
            }
        } else if (type == EnumPacketClient.SYNC_UPDATE) {
            int synctype = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            SyncController.clientSyncUpdate(synctype, compound, buffer);
        } else if (type == EnumPacketClient.SYNC_REMOVE) {
            int synctype = buffer.readInt();
            int id = buffer.readInt();
            SyncController.clientSyncRemove(synctype, id);
        } else if (type == EnumPacketClient.MARK_DATA) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityLivingBase)) {
                return;
            }
            MarkData data = MarkData.get((EntityLivingBase)entity);
            data.setNBT(Server.readNBT(buffer));
        } else if (type == EnumPacketClient.DIALOG) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            Dialog dialog = DialogController.instance.dialogs.get(buffer.readInt());
            NoppesUtil.openDialog(dialog, (EntityNPCInterface)entity, player);
        } else if (type == EnumPacketClient.DIALOG_DUMMY) {
            EntityDialogNpc npc = new EntityDialogNpc(player.field_70170_p);
            npc.display.setName(Server.readString(buffer));
            EntityUtil.Copy((EntityLivingBase)player, (EntityLivingBase)npc);
            Dialog dialog = new Dialog(null);
            dialog.readNBTPartial(Server.readNBT(buffer));
            NoppesUtil.openDialog(dialog, npc, player);
        } else if (type == EnumPacketClient.QUEST_COMPLETION) {
            int id = buffer.readInt();
            IQuest quest = QuestController.instance.get(id);
            if (!quest.getCompleteText().isEmpty()) {
                NoppesUtil.openGUI(player, new GuiQuestCompletion(quest));
            } else {
                NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestCompletion, id);
            }
        } else if (type == EnumPacketClient.EDIT_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                NoppesUtil.setLastNpc(null);
            } else {
                NoppesUtil.setLastNpc((EntityNPCInterface)entity);
            }
        } else if (type == EnumPacketClient.PLAY_MUSIC) {
            MusicController.Instance.playMusic(Server.readString(buffer), (Entity)player);
        } else if (type == EnumPacketClient.PLAY_SOUND) {
            MusicController.Instance.playSound(SoundCategory.VOICE, Server.readString(buffer), buffer.readFloat(), buffer.readFloat(), buffer.readFloat());
        } else if (type == EnumPacketClient.UPDATE_NPC) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).readSpawnData(compound);
        } else if (type == EnumPacketClient.ROLE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(compound.func_74762_e("EntityId"));
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).advanced.setRole(compound.func_74762_e("Role"));
            ((EntityNPCInterface)entity).roleInterface.readFromNBT(compound);
            NoppesUtil.setLastNpc((EntityNPCInterface)entity);
        } else if (type == EnumPacketClient.GUI) {
            EnumGuiType gui = EnumGuiType.values()[buffer.readInt()];
            CustomNpcs.proxy.openGui(NoppesUtil.getLastNpc(), gui, buffer.readInt(), buffer.readInt(), buffer.readInt());
        } else if (type == EnumPacketClient.PARTICLE) {
            NoppesUtil.spawnParticle(buffer);
        } else if (type == EnumPacketClient.DELETE_NPC) {
            Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(buffer.readInt());
            if (entity == null || !(entity instanceof EntityNPCInterface)) {
                return;
            }
            ((EntityNPCInterface)entity).delete();
        } else if (type == EnumPacketClient.SCROLL_LIST) {
            NoppesUtil.setScrollList(buffer);
        } else if (type == EnumPacketClient.SCROLL_DATA) {
            NoppesUtil.setScrollData(buffer);
        } else if (type == EnumPacketClient.SCROLL_DATA_PART) {
            NoppesUtil.addScrollData(buffer);
        } else if (type == EnumPacketClient.SCROLL_SELECTED) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IScrollData)) {
                return;
            }
            String selected = Server.readString(buffer);
            ((IScrollData)gui).setSelected(selected);
        } else if (type == EnumPacketClient.CLONE) {
            NBTTagCompound compound = Server.readNBT(buffer);
            NoppesUtil.openGUI(player, new GuiNpcMobSpawnerAdd(compound));
        } else if (type == EnumPacketClient.GUI_DATA) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof GuiNPCInterface && ((GuiNPCInterface)gui).hasSubGui()) {
                gui = ((GuiNPCInterface)gui).getSubGui();
            } else if (gui instanceof GuiContainerNPCInterface && ((GuiContainerNPCInterface)gui).hasSubGui()) {
                gui = ((GuiContainerNPCInterface)gui).getSubGui();
            }
            if (gui instanceof IGuiData) {
                ((IGuiData)gui).setGuiData(Server.readNBT(buffer));
            }
        } else if (type == EnumPacketClient.GUI_ERROR) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null || !(gui instanceof IGuiError)) {
                return;
            }
            int i = buffer.readInt();
            NBTTagCompound compound = Server.readNBT(buffer);
            ((IGuiError)gui).setError(i, compound);
        } else if (type == EnumPacketClient.GUI_CLOSE) {
            GuiScreen gui = Minecraft.func_71410_x().field_71462_r;
            if (gui == null) {
                return;
            }
            if (gui instanceof IGuiClose) {
                int i = buffer.readInt();
                NBTTagCompound compound = Server.readNBT(buffer);
                ((IGuiClose)gui).setClose(i, compound);
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a(null);
            mc.func_71381_h();
        } else if (type == EnumPacketClient.VILLAGER_LIST) {
            MerchantRecipeList merchantrecipelist = MerchantRecipeList.func_151390_b((PacketBuffer)new PacketBuffer(buffer));
            ServerEventsHandler.Merchant.func_70930_a(merchantrecipelist);
        } else if (type == EnumPacketClient.CONFIG && (config = buffer.readInt()) == 0) {
            final String font = Server.readString(buffer);
            final int size = buffer.readInt();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    if (!font.isEmpty()) {
                        CustomNpcs.FontType = font;
                        CustomNpcs.FontSize = size;
                        ClientProxy.Font.clear();
                        ClientProxy.Font = new ClientProxy.FontContainer(CustomNpcs.FontType, CustomNpcs.FontSize);
                        CustomNpcs.Config.updateConfig();
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("Font set to %s", new Object[]{ClientProxy.Font.getName()}));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("Current font is %s", new Object[]{ClientProxy.Font.getName()}));
                    }
                }
            };
            Minecraft.func_71410_x().func_152344_a(run);
        }
    }
}

