/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.quests.QuestLocation;

public class TileWaypoint
extends TileNpcEntity
implements ITickable {
    public String name = "";
    private int ticks = 10;
    private List<EntityPlayer> recentlyChecked = new ArrayList<EntityPlayer>();
    private List<EntityPlayer> toCheck;
    public int range = 10;

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.name.isEmpty()) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 10;
        this.toCheck = this.getPlayerList(this.range, this.range, this.range);
        this.toCheck.removeAll(this.recentlyChecked);
        List<EntityPlayer> listMax = this.getPlayerList(this.range + 10, this.range + 10, this.range + 10);
        this.recentlyChecked.retainAll(listMax);
        this.recentlyChecked.addAll(this.toCheck);
        if (this.toCheck.isEmpty()) {
            return;
        }
        for (EntityPlayer player : this.toCheck) {
            PlayerData pdata = PlayerData.get(player);
            PlayerQuestData playerdata = pdata.questData;
            for (QuestData data : playerdata.activeQuests.values()) {
                QuestLocation quest;
                if (data.quest.type != 3 || !(quest = (QuestLocation)data.quest.questInterface).setFound(data, this.name)) continue;
                player.func_145747_a((ITextComponent)new TextComponentTranslation(this.name + " " + I18n.func_74838_a((String)"quest.found"), new Object[0]));
                playerdata.checkQuestCompletion(player, 3);
                pdata.updateClient();
            }
        }
    }

    private List<EntityPlayer> getPlayerList(int x, int y, int z) {
        return this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)x, (double)y, (double)z));
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.name = compound.func_74779_i("LocationName");
        this.range = compound.func_74762_e("LocationRange");
        if (this.range < 2) {
            this.range = 2;
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        if (!this.name.isEmpty()) {
            compound.func_74778_a("LocationName", this.name);
        }
        compound.func_74768_a("LocationRange", this.range);
        return super.func_189515_b(compound);
    }
}

