/*
 * Decompiled with CFR 0.152.
 */
package dungeondq.Block;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockObserver;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RedstoneWire2
extends Block {
    public static final PropertyEnum<EnumAttachPosition> NORTH = PropertyEnum.func_177709_a((String)"north", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> EAST = PropertyEnum.func_177709_a((String)"east", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> SOUTH = PropertyEnum.func_177709_a((String)"south", EnumAttachPosition.class);
    public static final PropertyEnum<EnumAttachPosition> WEST = PropertyEnum.func_177709_a((String)"west", EnumAttachPosition.class);
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    protected static final AxisAlignedBB[] REDSTONE_WIRE_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 0.8125, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.1875, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.1875, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 0.8125), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0)};
    private boolean canProvidePower = true;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public RedstoneWire2() {
        super(Material.field_151575_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(NORTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(EAST, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(SOUTH, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a(WEST, (Comparable)((Object)EnumAttachPosition.NONE)).func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return REDSTONE_WIRE_AABB[RedstoneWire2.getAABBIndex(state.func_185899_b(source, pos))];
    }

    private static int getAABBIndex(IBlockState state) {
        boolean flag3;
        int i = 0;
        boolean flag = state.func_177229_b(NORTH) != EnumAttachPosition.NONE;
        boolean flag1 = state.func_177229_b(EAST) != EnumAttachPosition.NONE;
        boolean flag2 = state.func_177229_b(SOUTH) != EnumAttachPosition.NONE;
        boolean bl = flag3 = state.func_177229_b(WEST) != EnumAttachPosition.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        return i;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = state.func_177226_a(WEST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.WEST)));
        state = state.func_177226_a(EAST, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.EAST)));
        state = state.func_177226_a(NORTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.NORTH)));
        state = state.func_177226_a(SOUTH, (Comparable)((Object)this.getAttachPosition(worldIn, pos, EnumFacing.SOUTH)));
        return state;
    }

    private EnumAttachPosition getAttachPosition(IBlockAccess worldIn, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (!(RedstoneWire2.canConnectTo(worldIn.func_180495_p(blockpos), direction, worldIn, blockpos) || !iblockstate.func_185915_l() && RedstoneWire2.canConnectUpwardsTo(worldIn, blockpos.func_177977_b()))) {
            IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177984_a());
            if (!iblockstate1.func_185915_l()) {
                boolean flag;
                boolean bl = flag = worldIn.func_180495_p(blockpos).isSideSolid(worldIn, blockpos, EnumFacing.UP) || worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150426_aN;
                if (flag && RedstoneWire2.canConnectUpwardsTo(worldIn, blockpos.func_177984_a())) {
                    if (iblockstate.func_185898_k()) {
                        return EnumAttachPosition.UP;
                    }
                    return EnumAttachPosition.SIDE;
                }
            }
            return EnumAttachPosition.NONE;
        }
        return EnumAttachPosition.SIDE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    private IBlockState updateSurroundingRedstone(World worldIn, BlockPos pos, IBlockState state) {
        state = this.calculateCurrentChanges(worldIn, pos, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_175685_c(blockpos, (Block)this, false);
        }
        return state;
    }

    private IBlockState calculateCurrentChanges(World worldIn, BlockPos pos1, BlockPos pos2, IBlockState state) {
        IBlockState iblockstate = state;
        int i = (Integer)state.func_177229_b((IProperty)POWER);
        int j = 0;
        j = this.getMaxCurrentStrength(worldIn, pos2, j);
        this.canProvidePower = false;
        int k = worldIn.func_175687_A(pos1);
        this.canProvidePower = true;
        if (k > 0 && k > j - 1) {
            j = k;
        }
        int l = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            boolean flag;
            BlockPos blockpos = pos1.func_177972_a(enumfacing);
            boolean bl = flag = blockpos.func_177958_n() != pos2.func_177958_n() || blockpos.func_177952_p() != pos2.func_177952_p();
            if (flag) {
                l = this.getMaxCurrentStrength(worldIn, blockpos, l);
            }
            if (worldIn.func_180495_p(blockpos).func_185915_l() && !worldIn.func_180495_p(pos1.func_177984_a()).func_185915_l()) {
                if (!flag || pos1.func_177956_o() < pos2.func_177956_o()) continue;
                l = this.getMaxCurrentStrength(worldIn, blockpos.func_177984_a(), l);
                continue;
            }
            if (worldIn.func_180495_p(blockpos).func_185915_l() || !flag || pos1.func_177956_o() > pos2.func_177956_o()) continue;
            l = this.getMaxCurrentStrength(worldIn, blockpos.func_177977_b(), l);
        }
        j = l > j ? l - 1 : (j > 0 ? --j : 0);
        if (k > j - 1) {
            j = k;
        }
        if (i != j) {
            state = state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(j));
            if (worldIn.func_180495_p(pos1) == iblockstate) {
                worldIn.func_180501_a(pos1, state, 2);
            }
            this.blocksNeedingUpdate.add(pos1);
            for (EnumFacing enumfacing1 : EnumFacing.values()) {
                this.blocksNeedingUpdate.add(pos1.func_177972_a(enumfacing1));
            }
        }
        return state;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_175685_c(pos, (Block)this, false);
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (EnumFacing enumfacing : EnumFacing.Plane.VERTICAL) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_175685_c(pos.func_177972_a(enumfacing), (Block)this, false);
            }
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(enumfacing1));
            }
            for (EnumFacing enumfacing2 : EnumFacing.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(enumfacing2);
                if (worldIn.func_180495_p(blockpos).func_185915_l()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    private int getMaxCurrentStrength(World worldIn, BlockPos pos, int strength) {
        if (worldIn.func_180495_p(pos).func_177230_c() != this) {
            return strength;
        }
        int i = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)POWER);
        return i > strength ? i : strength;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.func_176196_c(worldIn, pos)) {
                this.updateSurroundingRedstone(worldIn, pos, state);
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151137_ax;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !this.canProvidePower ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.canProvidePower) {
            return 0;
        }
        int i = (Integer)blockState.func_177229_b((IProperty)POWER);
        if (i == 0) {
            return 0;
        }
        if (side == EnumFacing.UP) {
            return i;
        }
        EnumSet<EnumFacing> enumset = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (!this.isPowerSourceAt(blockAccess, pos, enumfacing)) continue;
            enumset.add(enumfacing);
        }
        if (side.func_176740_k().func_176722_c() && enumset.isEmpty()) {
            return i;
        }
        if (enumset.contains(side) && !enumset.contains(side.func_176735_f()) && !enumset.contains(side.func_176746_e())) {
            return i;
        }
        return 0;
    }

    private boolean isPowerSourceAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_185915_l();
        boolean flag1 = worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        return !flag1 && flag && RedstoneWire2.canConnectUpwardsTo(worldIn, blockpos.func_177984_a()) ? true : (RedstoneWire2.canConnectTo(iblockstate, side, worldIn, pos) ? true : (iblockstate.func_177230_c() == Blocks.field_150416_aS && iblockstate.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) == side ? true : !flag && RedstoneWire2.canConnectUpwardsTo(worldIn, blockpos.func_177977_b())));
    }

    protected static boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return RedstoneWire2.canConnectTo(worldIn.func_180495_p(pos), null, worldIn, pos);
    }

    protected static boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side, IBlockAccess world, BlockPos pos) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (Blocks.field_150413_aR.func_185547_C(blockState)) {
            EnumFacing enumfacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D);
            return enumfacing == side || enumfacing.func_176734_d() == side;
        }
        return Blocks.field_190976_dk == blockState.func_177230_c() ? side == blockState.func_177229_b((IProperty)BlockObserver.field_176387_N) : blockState.func_177230_c().canConnectRedstone(blockState, world, pos, side);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    @SideOnly(value=Side.CLIENT)
    public static int colorMultiplier(int p_176337_0_) {
        float f = (float)p_176337_0_ / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (p_176337_0_ == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f3 < 0.0f) {
            f3 = 0.0f;
        }
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((IProperty)POWER);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)pos.func_177956_o() + 0.0625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            worldIn.func_175688_a(EnumParticleTypes.REDSTONE, d0, d1, d2, (double)f1, (double)f2, (double)f3, new int[0]);
        }
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(Items.field_151137_ax);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(SOUTH, state.func_177229_b(NORTH)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(EAST)).func_177226_a(EAST, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return state.func_177226_a(NORTH, state.func_177229_b(WEST)).func_177226_a(EAST, state.func_177229_b(NORTH)).func_177226_a(SOUTH, state.func_177229_b(EAST)).func_177226_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return state.func_177226_a(NORTH, state.func_177229_b(SOUTH)).func_177226_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return state.func_177226_a(EAST, state.func_177229_b(WEST)).func_177226_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, POWER});
    }

    static enum EnumAttachPosition implements IStringSerializable
    {
        UP("up"),
        SIDE("side"),
        NONE("none");

        private final String name;

        private EnumAttachPosition(String name) {
            this.name = name;
        }

        public String toString() {
            return this.func_176610_l();
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

