/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue.common.network.client;

import com.shinoow.grue.common.entity.cap.GrueCapabilityProvider;
import com.shinoow.grue.common.entity.cap.IGrueTimerCapability;
import com.shinoow.grue.common.network.AbstractMessage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;

public class GrueTimerMessage
extends AbstractMessage.AbstractClientMessage<GrueTimerMessage> {
    private int timer;
    private int daylightTimer;
    private boolean dynLight;

    public GrueTimerMessage() {
    }

    public GrueTimerMessage(EntityPlayer player) {
        IGrueTimerCapability cap = (IGrueTimerCapability)player.getCapability(GrueCapabilityProvider.GRUE_TIMER, null);
        this.timer = cap.getTimer();
        this.daylightTimer = cap.getDaylightTimer();
        this.dynLight = cap.hasDynamicLights();
    }

    @Override
    protected void read(PacketBuffer buffer) throws IOException {
        this.timer = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.daylightTimer = ByteBufUtils.readVarInt((ByteBuf)buffer, (int)5);
        this.dynLight = buffer.readBoolean();
    }

    @Override
    protected void write(PacketBuffer buffer) throws IOException {
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.timer, (int)5);
        ByteBufUtils.writeVarInt((ByteBuf)buffer, (int)this.daylightTimer, (int)5);
        buffer.writeBoolean(this.dynLight);
    }

    @Override
    public void process(EntityPlayer player, Side side) {
        if (player.hasCapability(GrueCapabilityProvider.GRUE_TIMER, null)) {
            IGrueTimerCapability cap = (IGrueTimerCapability)player.getCapability(GrueCapabilityProvider.GRUE_TIMER, null);
            cap.setTimer(this.timer);
            cap.setDaylightTimer(this.daylightTimer);
            cap.setHasDynamicLights(this.dynLight);
        }
    }
}

