/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.grue;

import com.google.common.collect.Lists;
import com.shinoow.grue.common.CommonProxy;
import com.shinoow.grue.common.entity.EntityDaylightGrue;
import com.shinoow.grue.common.entity.EntityGrue;
import com.shinoow.grue.common.entity.cap.GrueTimerCapability;
import com.shinoow.grue.common.entity.cap.GrueTimerCapabilityStorage;
import com.shinoow.grue.common.entity.cap.IGrueTimerCapability;
import com.shinoow.grue.common.handlers.GrueEventHandler;
import com.shinoow.grue.common.network.PacketDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

@Mod(modid="grue", name="Grue", version="1.3.5", dependencies="required-after:forge@[14.21.1.2406,)", acceptedMinecraftVersions="[1.12]", guiFactory="com.shinoow.grue.client.config.GrueGuiFactory", updateJSON="https://raw.githubusercontent.com/Shinoow/Grue/master/version.json", useMetadata=false)
public class Grue {
    public static final String version = "1.3.5";
    public static final String modid = "grue";
    public static final String name = "Grue";
    @Mod.Metadata(value="grue")
    public static ModMetadata metadata;
    @Mod.Instance(value="grue")
    public static Grue instance;
    @SidedProxy(clientSide="com.shinoow.grue.client.ClientProxy", serverSide="com.shinoow.grue.common.CommonProxy")
    public static CommonProxy proxy;
    public static Configuration cfg;
    public static boolean dynamicLightsMode;
    public static boolean daylightGrue;
    public static boolean useWhitelist;
    public static boolean wimpMode;
    public static boolean displayWarningText;
    public static int spawnTimer;
    public static int flyHeight;
    public static int[] dimWhitelist;
    public static String[] dynLightsList;
    public static final List<Integer> whitelist_override;
    public static final List<ItemStack> dynamic_lights_list;
    public static final DamageSource grueDamage;
    public static final DamageSource daylightGrueDamage;
    public static final DamageSource wimpGrueDamage;
    public static SoundEvent grue_spawn;
    public static SoundEvent grue_whisper;
    public static SoundEvent grue_death;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        metadata = event.getModMetadata();
        Grue.metadata.description = Grue.metadata.description + "\n\n\u00a76Supporters: " + this.getSupporterList() + "\u00a7r";
        instance = this;
        MinecraftForge.EVENT_BUS.register((Object)new GrueEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        cfg = new Configuration(event.getSuggestedConfigurationFile());
        Grue.syncConfig();
        grue_spawn = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "grue.spawn")).setRegistryName(new ResourceLocation(modid, "grue.spawn"));
        grue_whisper = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "grue.whisper")).setRegistryName(new ResourceLocation(modid, "grue.whisper"));
        grue_death = (SoundEvent)new SoundEvent(new ResourceLocation(modid, "grue.death")).setRegistryName(new ResourceLocation(modid, "grue.death"));
        CapabilityManager.INSTANCE.register(IGrueTimerCapability.class, GrueTimerCapabilityStorage.instance, GrueTimerCapability.class);
        Grue.registerEntityWithEgg(EntityGrue.class, "EntityGrue", 1, 80, 3, true, 0, 0);
        if (daylightGrue) {
            Grue.registerEntityWithEgg(EntityDaylightGrue.class, "EntityDaylightGrue", 2, 80, 3, true, 0xFFFFFF, 0xFFFFFF);
        }
        PacketDispatcher.registerPackets();
        proxy.preInit();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        this.buildItemList();
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        ArrayList<String> senders = new ArrayList<String>();
        for (FMLInterModComms.IMCMessage imcMessage : event.getMessages()) {
            if (imcMessage.key.equals("registerDimensionWhitelistOverride")) {
                int id = Integer.valueOf(imcMessage.getStringValue());
                whitelist_override.add(id);
                FMLLog.log((String)name, (Level)Level.INFO, (String)"Received Dimension Whitelist Override for dimension %s from mod %s", (Object[])new Object[]{imcMessage.getStringValue(), imcMessage.getSender()});
                if (senders.contains(imcMessage.getSender())) continue;
                senders.add(imcMessage.getSender());
                continue;
            }
            FMLLog.log((String)name, (Level)Level.WARN, (String)"Received an IMC Message with unknown key (%s) from mod %s!", (Object[])new Object[]{imcMessage.key, imcMessage.getSender()});
        }
        if (!senders.isEmpty()) {
            FMLLog.log((String)name, (Level)Level.INFO, (String)"Recieved messages from the following mods: %s", (Object[])new Object[]{senders});
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals(modid)) {
            Grue.syncConfig();
        }
    }

    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        event.getRegistry().register((IForgeRegistryEntry)grue_spawn);
        event.getRegistry().register((IForgeRegistryEntry)grue_whisper);
        event.getRegistry().register((IForgeRegistryEntry)grue_death);
    }

    private static void syncConfig() {
        daylightGrue = cfg.get("general", "Daylight Grue", false, "Enable this if you want Daylight Grues to appear where the light level is 14 or higher.\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getBoolean();
        spawnTimer = cfg.getInt("Grue spawn timer", "general", 10, 1, 60, "Change the value to increase the time it takes before a Grue spawns.\n");
        wimpMode = cfg.get("general", "Wimp mode", false, "Toggles wimp-mode, which reduces the Grue's damage output to 3 hearts (a 6.505213034913026604750013415713e-19th of the default).").getBoolean();
        useWhitelist = cfg.get("general", "Grue dimension whitelist", false, "Toggles the Grue dimension whitelist (used to force the Grues to only spawn in certain dimensions).").getBoolean();
        dimWhitelist = cfg.get("general", "Whitelist", new int[]{0}, "Add dimension IDs to this list if you want Grues to spawn here.\n" + TextFormatting.RED + "[Only used if Grue dimension whitelist is enabled]" + TextFormatting.RESET).getIntList();
        displayWarningText = cfg.get("general", "Display Warning Text", true, "Toggles whether or not to display the warning text when in dark areas. [CLIENT ONLY]").getBoolean();
        dynamicLightsMode = cfg.get("general", "Dynamic Lights Mode", false, "If this is enabled (client and server), you will be able to repel Grue with handheld light sources while AtomicStryker's Dynamic Lights is present.").getBoolean();
        flyHeight = cfg.getInt("Flying Height", "general", 2, 0, 3, "The height above ground at which a Grue will still spawn (the spawning waits if you're flying above the height). If set to 0, it will act as if you're not flying\n");
        dynLightsList = cfg.get("general", "Dynamic Lights List", new String[]{"minecraft:torch", "minecraft:redstone_torch", "minecraft:glowstone"}, "Items/Blocks added to this list will be regarded as handheld light sources while AtomicStryker's Dynamic Lights is present(and Dynamic Lights Mode is enabled).\nFormat: modid:name:meta, where meta is optional.\n" + TextFormatting.RED + "[Minecraft Restart Required]" + TextFormatting.RESET).getStringList();
        if (cfg.hasChanged()) {
            cfg.save();
        }
    }

    private void buildItemList() {
        if (dynLightsList.length > 0) {
            for (String str : dynLightsList) {
                if (str.length() <= 0) continue;
                String[] stuff = str.split(":");
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(stuff[0], stuff[1]));
                if (item != null) {
                    dynamic_lights_list.add(new ItemStack(item, 1, stuff.length == 3 ? Integer.valueOf(stuff[2]) : Short.MAX_VALUE));
                    continue;
                }
                FMLLog.log((String)name, (Level)Level.ERROR, (String)"%s is not a valid Item!", (Object[])new Object[]{str});
            }
        }
    }

    private static void registerEntityWithEgg(Class<? extends Entity> entity, String name, int modid, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int primaryColor, int secondaryColor) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(modid, name.toLowerCase(Locale.ENGLISH)), entity, (String)("grue." + name), (int)modid, (Object)instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates, (int)primaryColor, (int)secondaryColor);
    }

    private String getSupporterList() {
        String names = "";
        try {
            BufferedReader nameFile = new BufferedReader(new InputStreamReader(new URL("https://raw.githubusercontent.com/Shinoow/AbyssalCraft/master/supporters.txt").openStream()));
            names = nameFile.readLine();
            nameFile.close();
        }
        catch (IOException e) {
            FMLLog.log((String)name, (Level)Level.ERROR, (String)"Failed to fetch supporter list, using local version!", (Object[])new Object[0]);
            names = "Tedyhere";
        }
        return names;
    }

    static {
        instance = new Grue();
        whitelist_override = Lists.newArrayList();
        dynamic_lights_list = Lists.newArrayList();
        grueDamage = new DamageSource(modid).func_76348_h().func_151518_m();
        daylightGrueDamage = new DamageSource("daylightgrue").func_76348_h().func_151518_m();
        wimpGrueDamage = new DamageSource("wimpgrue");
    }
}

