/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.common.storage.item;

import com.cjm721.overloaded.common.storage.INBTConvertible;
import com.cjm721.overloaded.common.storage.LongItemStack;
import com.cjm721.overloaded.common.storage.item.IHyperHandlerItem;
import com.cjm721.overloaded.common.util.ItemUtil;
import com.cjm721.overloaded.common.util.NumberUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;

public class LongItemStorage
implements IItemHandler,
IHyperHandlerItem,
INBTConvertible {
    @Nonnull
    private LongItemStack longItemStack = new LongItemStack(null, 0L);

    public int getSlots() {
        return 1;
    }

    @Nullable
    public ItemStack getStackInSlot(int slot) {
        if (this.longItemStack.getItemStack() != null) {
            this.longItemStack.getItemStack().field_77994_a = (int)Math.min(Integer.MAX_VALUE, this.longItemStack.getAmount());
            return this.longItemStack.getItemStack();
        }
        return null;
    }

    @Nullable
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        LongItemStack result = this.give(new LongItemStack(stack, stack.field_77994_a), !simulate);
        if (result.getAmount() == 0L) {
            return null;
        }
        ItemStack toReturn = stack.func_77946_l();
        toReturn.field_77994_a = (int)result.getAmount();
        return toReturn;
    }

    @Nullable
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        LongItemStack result = this.take(new LongItemStack(null, amount), !simulate);
        if (result.getAmount() == 0L) {
            return null;
        }
        ItemStack toReturn = result.getItemStack().func_77946_l();
        toReturn.field_77994_a = (int)result.getAmount();
        return toReturn;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (this.longItemStack.getItemStack() != null) {
            compound.func_74782_a("Item", (NBTBase)this.longItemStack.getItemStack().serializeNBT());
            compound.func_74772_a("Count", this.longItemStack.getAmount());
        }
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        ItemStack storedItem;
        ItemStack itemStack = storedItem = compound.func_74764_b("Item") ? ItemStack.func_77949_a((NBTTagCompound)compound.func_74775_l("Item")) : null;
        if (storedItem != null) {
            long storedAmount = compound.func_74764_b("Count") ? compound.func_74763_f("Count") : 0L;
            this.longItemStack = new LongItemStack(storedItem, storedAmount);
        }
    }

    @Override
    @Nonnull
    public LongItemStack status() {
        return this.longItemStack;
    }

    @Override
    @Nonnull
    public LongItemStack give(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.longItemStack.getItemStack() == null) {
            if (doAction) {
                this.longItemStack = new LongItemStack(stack.getItemStack(), stack.getAmount());
            }
            return LongItemStack.EMPTY_STACK;
        }
        if (ItemUtil.itemsAreEqual(this.longItemStack.getItemStack(), stack.getItemStack())) {
            NumberUtil.AddReturn<Long> result = NumberUtil.addToMax(this.longItemStack.getAmount(), stack.getAmount());
            if (doAction) {
                this.longItemStack.setAmount((Long)result.result);
            }
            return new LongItemStack(stack.getItemStack(), (Long)result.overflow);
        }
        return stack;
    }

    @Override
    @Nonnull
    public LongItemStack take(@Nonnull LongItemStack stack, boolean doAction) {
        if (this.longItemStack.getItemStack() == null) {
            return LongItemStack.EMPTY_STACK;
        }
        long result = Math.min(stack.getAmount(), this.longItemStack.getAmount());
        LongItemStack toReturn = new LongItemStack(this.longItemStack.getItemStack(), result);
        if (doAction) {
            this.longItemStack.removeAmount(result);
            if (this.longItemStack.getAmount() == 0L) {
                this.longItemStack.setItemStack(null);
            }
        }
        return toReturn;
    }
}

