/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.common.item.functional;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.common.OverloadedCreativeTabs;
import com.cjm721.overloaded.common.block.ModBlocks;
import com.cjm721.overloaded.common.config.MultiToolConfig;
import com.cjm721.overloaded.common.config.RecipeEnabledConfig;
import com.cjm721.overloaded.common.item.ModItem;
import com.cjm721.overloaded.common.item.ModItems;
import com.cjm721.overloaded.common.network.packets.MultiToolLeftClickMessage;
import com.cjm721.overloaded.common.network.packets.MultiToolRightClickMessage;
import com.cjm721.overloaded.common.storage.LongEnergyStack;
import com.cjm721.overloaded.common.storage.energy.IHyperHandlerEnergy;
import com.cjm721.overloaded.common.util.BlockResult;
import com.cjm721.overloaded.common.util.CapabilityHyperEnergy;
import com.cjm721.overloaded.common.util.EnergyWrapper;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCommandBlock;
import net.minecraft.block.BlockStructure;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketBlockChange;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMultiTool
extends ModItem {
    private static final Set<String> toolClasses = ImmutableSet.of((Object)"pickaxe", (Object)"shovel", (Object)"axe");

    public ItemMultiTool() {
        this.func_77625_d(1);
        this.setRegistryName("multi_tool");
        this.func_77655_b("multi_tool");
        this.func_77637_a(OverloadedCreativeTabs.TECH);
        GameRegistry.register((IForgeRegistryEntry)this);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 15;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation location = new ModelResourceLocation(new ResourceLocation("overloaded", "multi_tool"), null);
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)location);
    }

    @Override
    public void registerRecipe() {
        if (RecipeEnabledConfig.multiTool) {
            GameRegistry.addRecipe((ItemStack)new ItemStack((Item)this), (Object[])new Object[]{"NI ", "IES", " SB", Character.valueOf('N'), Items.field_151156_bN, Character.valueOf('I'), Items.field_151042_j, Character.valueOf('E'), ModItems.energyCore, Character.valueOf('B'), Blocks.field_150339_S, Character.valueOf('S'), ModBlocks.netherStarBlock});
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        IHyperHandlerEnergy handler = (IHyperHandlerEnergy)stack.getCapability(CapabilityHyperEnergy.HYPER_ENERGY_HANDLER, null);
        tooltip.add("Energy Stored: " + ((LongEnergyStack)handler.status()).getAmount());
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull ItemStack itemStackIn, World worldIn, EntityPlayer player, EnumHand hand) {
        RayTraceResult result = worldIn.func_72933_a(player.func_174824_e(1.0f), player.func_174791_d().func_178787_e(player.func_70040_Z().func_186678_a((double)MultiToolConfig.reach)));
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            Overloaded.proxy.networkWrapper.sendToServer((IMessage)new MultiToolRightClickMessage(result.func_178782_a(), result.field_178784_b, (float)result.field_72307_f.field_72450_a - (float)result.func_178782_a().func_177958_n(), (float)result.field_72307_f.field_72448_b - (float)result.func_178782_a().func_177956_o(), (float)result.field_72307_f.field_72449_c - (float)result.func_178782_a().func_177952_p()));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    private BlockResult breakAndUseEnergy(@Nonnull World worldIn, @Nonnull BlockPos blockPos, @Nonnull LongEnergyStack energyStack, EntityPlayerMP player, int efficiency, int unbreaking) {
        IBlockState state = worldIn.func_180495_p(blockPos);
        float hardness = state.func_185887_b(worldIn, blockPos);
        if (hardness < 0.0f) {
            return BlockResult.FAIL_UNBREAKABLE;
        }
        float floatBreakCost = (float)MultiToolConfig.breakBaseCost + hardness * (float)MultiToolConfig.breakCostMultiplier / (float)(efficiency + 1) + (float)(100 / (unbreaking + 1)) + (float)blockPos.func_185332_f((int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        if (Float.isInfinite(floatBreakCost) || Float.isNaN(floatBreakCost)) {
            return BlockResult.FAIL_ENERGY;
        }
        long breakCost = Math.round(floatBreakCost);
        if (breakCost < 0L || energyStack.getAmount() < breakCost) {
            return BlockResult.FAIL_ENERGY;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(worldIn, blockPos, state, (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return BlockResult.FAIL_REMOVE;
        }
        this.drawParticleStreamTo((EntityPlayer)player, worldIn, blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        boolean result = this.tryHarvestBlock(player, worldIn, blockPos);
        if (result) {
            energyStack.amount -= breakCost;
            return BlockResult.SUCCESS;
        }
        return BlockResult.FAIL_REMOVE;
    }

    public boolean tryHarvestBlock(EntityPlayerMP player, World world, BlockPos pos) {
        boolean flag1;
        int exp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos);
        if (exp == -1) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        TileEntity tileentity = world.func_175625_s(pos);
        Block block = iblockstate.func_177230_c();
        if ((block instanceof BlockCommandBlock || block instanceof BlockStructure) && !player.func_189808_dh()) {
            world.func_184138_a(pos, iblockstate, iblockstate, 3);
            return false;
        }
        world.func_180498_a(null, 2001, pos, Block.func_176210_f((IBlockState)iblockstate));
        if (player.field_71134_c.func_73083_d()) {
            flag1 = this.removeBlock(world, pos, (EntityPlayer)player, false);
            player.field_71135_a.func_147359_a((Packet)new SPacketBlockChange(world, pos));
        } else {
            ItemStack itemstack1 = player.func_184614_ca();
            boolean flag = iblockstate.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, (EntityPlayer)player);
            itemstack1.func_179548_a(world, iblockstate, pos, (EntityPlayer)player);
            flag1 = this.removeBlock(world, pos, (EntityPlayer)player, flag);
            if (flag1 && flag) {
                iblockstate.func_177230_c().func_180657_a(world, (EntityPlayer)player, pos, iblockstate, tileentity, itemstack1.func_77946_l());
            }
        }
        if (!player.func_184812_l_() && flag1 && exp > 0) {
            iblockstate.func_177230_c().func_180637_b(world, player.func_180425_c(), exp);
        }
        return flag1;
    }

    private boolean removeBlock(World world, BlockPos pos, EntityPlayer player, boolean canHarvest) {
        IBlockState iblockstate = world.func_180495_p(pos);
        boolean flag = iblockstate.func_177230_c().removedByPlayer(iblockstate, world, pos, player, canHarvest);
        if (flag) {
            iblockstate.func_177230_c().func_176206_d(world, pos, iblockstate);
        }
        return flag;
    }

    public void drawParticleStreamTo(EntityPlayer source, World world, double x, double y, double z) {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void leftClickBlock(@Nonnull PlayerInteractEvent.LeftClickBlock event) {
        if (event.getSide() == Side.SERVER || event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack != null && stack.func_77973_b().equals((Object)this)) {
            this.leftClickOnBlockClient(event.getPos());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void leftClickEmpty(@Nonnull PlayerInteractEvent.LeftClickEmpty event) {
        EntityPlayer entityLiving;
        RayTraceResult result;
        if (event.getSide() == Side.SERVER || event.getEntityPlayer() != Minecraft.func_71410_x().field_71439_g) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (stack != null && stack.func_77973_b().equals((Object)this) && (result = (entityLiving = event.getEntityPlayer()).func_174822_a((double)MultiToolConfig.reach, 0.0f)) != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
            this.leftClickOnBlockClient(result.func_178782_a());
        }
    }

    @SubscribeEvent
    public void teleportDrops(@Nonnull BlockEvent.HarvestDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getHarvester();
        if (player == null || player.func_184614_ca() == null || player.func_184614_ca().func_77973_b() != this) {
            return;
        }
        World world = event.getWorld();
        float chance = event.getDropChance();
        for (ItemStack stack : event.getDrops()) {
            if (!(world.field_73012_v.nextFloat() <= chance)) continue;
            EntityItem toSpawn = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, stack);
            world.func_72838_d((Entity)toSpawn);
        }
        event.getDrops().clear();
    }

    private void leftClickOnBlockClient(BlockPos pos) {
        MultiToolLeftClickMessage message = new MultiToolLeftClickMessage(pos);
        Overloaded.proxy.networkWrapper.sendToServer((IMessage)message);
    }

    public void leftClickOnBlockServer(@Nonnull World world, @Nonnull EntityPlayerMP player, @Nonnull BlockPos pos) {
        ItemStack itemStack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (itemStack.func_77973_b() != this || world.func_175623_d(pos)) {
            return;
        }
        player.func_184598_c(EnumHand.MAIN_HAND);
        if (player.func_70093_af()) {
            NBTTagCompound tag = itemStack.func_77978_p();
            if (tag == null) {
                tag = new NBTTagCompound();
            }
            IBlockState state = world.func_180495_p(pos);
            Item item = Item.func_150898_a((Block)state.func_177230_c());
            ItemStack stackToPlace = new ItemStack(item, 1, state.func_177230_c().func_180651_a(state));
            NBTTagCompound blockTag = new NBTTagCompound();
            stackToPlace.func_77955_b(blockTag);
            tag.func_74782_a("Item", (NBTBase)blockTag);
            itemStack.func_77982_d(tag);
            ITextComponent component = stackToPlace.func_151000_E();
            player.func_145747_a(new TextComponentString("Bound tool to ").func_150257_a(component));
        } else {
            IHyperHandlerEnergy energy = (IHyperHandlerEnergy)itemStack.getCapability(CapabilityHyperEnergy.HYPER_ENERGY_HANDLER, null);
            LongEnergyStack energyStack = energy.take(new LongEnergyStack(Long.MAX_VALUE), true);
            int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)itemStack);
            int unbreaking = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)itemStack);
            switch (this.breakAndUseEnergy(world, pos, energyStack, player, efficiency, unbreaking)) {
                case FAIL_REMOVE: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unable to break block, reason unknown"));
                    break;
                }
                case FAIL_ENERGY: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Unable to break block, not enough energy"));
                    break;
                }
                case FAIL_UNBREAKABLE: {
                    player.func_145747_a((ITextComponent)new TextComponentString("Block is unbreakable"));
                    break;
                }
            }
            energy.give(energyStack, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rightClickWithItem(@Nonnull World worldIn, @Nonnull EntityPlayerMP player, @Nonnull BlockPos pos, @Nonnull EnumFacing sideHit, float hitX, float hitY, float hitZ) {
        ItemStack multiTool = player.func_184614_ca();
        if (multiTool.func_77973_b() != this) {
            return;
        }
        NBTTagCompound tagCompound = multiTool.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Item")) {
            player.func_145747_a((ITextComponent)new TextComponentString("No block type selected to place."));
            return;
        }
        NBTTagCompound itemTag = tagCompound.func_74775_l("Item");
        ItemStack blockStack = ItemStack.func_77949_a((NBTTagCompound)itemTag);
        if (blockStack == null || !(blockStack.func_77973_b() instanceof ItemBlock)) {
            player.func_145747_a((ITextComponent)new TextComponentString("No valid block type selected to place."));
            return;
        }
        IHyperHandlerEnergy energy = (IHyperHandlerEnergy)multiTool.getCapability(CapabilityHyperEnergy.HYPER_ENERGY_HANDLER, null);
        LongEnergyStack energyStack = energy.take(new LongEnergyStack(Long.MAX_VALUE), true);
        Vec3i sideVector = sideHit.func_176730_m();
        BlockPos newPosition = pos.func_177971_a(sideVector);
        try {
            if (!this.placeBlock(blockStack, player, worldIn, newPosition, sideHit, energyStack, hitX, hitY, hitZ)) {
                return;
            }
            if (!player.func_70093_af()) return;
            BlockPos playerPos = player.func_180425_c();
            switch (sideHit) {
                case UP: {
                    do {
                        if (newPosition.func_177956_o() >= playerPos.func_177956_o()) return;
                    } while (this.placeBlock(blockStack, player, worldIn, newPosition = newPosition.func_177971_a(sideVector), sideHit, energyStack, hitX, hitY, hitZ));
                    return;
                }
                case DOWN: {
                    do {
                        if (newPosition.func_177956_o() <= playerPos.func_177956_o()) return;
                    } while (this.placeBlock(blockStack, player, worldIn, newPosition = newPosition.func_177971_a(sideVector), sideHit, energyStack, hitX, hitY, hitZ));
                    return;
                }
                case NORTH: {
                    do {
                        if (newPosition.func_177952_p() <= playerPos.func_177952_p()) return;
                    } while (this.placeBlock(blockStack, player, worldIn, newPosition = newPosition.func_177971_a(sideVector), sideHit, energyStack, hitX, hitY, hitZ));
                    return;
                }
                case SOUTH: {
                    do {
                        if (newPosition.func_177952_p() >= playerPos.func_177952_p()) return;
                    } while (this.placeBlock(blockStack, player, worldIn, newPosition = newPosition.func_177971_a(sideVector), sideHit, energyStack, hitX, hitY, hitZ));
                    return;
                }
                case EAST: {
                    do {
                        if (newPosition.func_177958_n() >= playerPos.func_177958_n()) return;
                    } while (this.placeBlock(blockStack, player, worldIn, newPosition = newPosition.func_177971_a(sideVector), sideHit, energyStack, hitX, hitY, hitZ));
                    return;
                }
                case WEST: {
                    do {
                        if (newPosition.func_177958_n() <= playerPos.func_177958_n()) return;
                    } while (this.placeBlock(blockStack, player, worldIn, newPosition = newPosition.func_177971_a(sideVector), sideHit, energyStack, hitX, hitY, hitZ));
                    return;
                }
            }
            return;
        }
        finally {
            energy.give(energyStack, true);
        }
    }

    private boolean placeBlock(@Nonnull ItemStack searchStack, @Nonnull EntityPlayerMP player, @Nonnull World worldIn, @Nonnull BlockPos newPosition, @Nonnull EnumFacing facing, @Nonnull LongEnergyStack energyStack, float hitX, float hitY, float hitZ) {
        ItemBlock itemBlock = (ItemBlock)searchStack.func_77973_b();
        if (!worldIn.func_175716_a(itemBlock.func_179223_d(), newPosition, false, facing, (Entity)player, searchStack)) {
            return false;
        }
        BlockEvent.PlaceEvent event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)new BlockSnapshot(worldIn, newPosition, worldIn.func_180495_p(newPosition)), (EnumFacing)facing, (EnumHand)EnumHand.MAIN_HAND);
        if (event.isCanceled()) {
            return false;
        }
        long distance = Math.round(player.func_180425_c().func_185332_f(newPosition.func_177958_n(), newPosition.func_177956_o(), newPosition.func_177952_p()));
        long cost = MultiToolConfig.placeBaseCost + MultiToolConfig.costPerMeterAway * distance;
        if (cost < 0L || energyStack.amount < cost) {
            return false;
        }
        int foundStackSlot = this.findItemStack(searchStack, player);
        if (foundStackSlot == -1) {
            return false;
        }
        player.field_71071_by.func_70301_a(foundStackSlot);
        ItemStack foundStack = player.field_71071_by.func_70301_a(foundStackSlot);
        int i = itemBlock.func_77647_b(foundStack.func_77960_j());
        IBlockState iblockstate1 = itemBlock.field_150939_a.getStateForPlacement(worldIn, newPosition, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, foundStack);
        if (itemBlock.placeBlockAt(foundStack, (EntityPlayer)player, worldIn, newPosition, facing, hitX, hitY, hitZ, iblockstate1)) {
            SoundType soundtype = worldIn.func_180495_p(newPosition).func_177230_c().getSoundType(worldIn.func_180495_p(newPosition), worldIn, newPosition, (Entity)player);
            worldIn.func_184133_a(null, newPosition, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            foundStack.func_77979_a(1);
            if (foundStack.field_77994_a == 0) {
                player.field_71071_by.func_70304_b(foundStackSlot);
            }
            return true;
        }
        return false;
    }

    private int findItemStack(@Nonnull ItemStack item, @Nonnull EntityPlayerMP player) {
        int size = player.field_71071_by.func_70302_i_();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || !stack.func_77969_a(item)) continue;
            return i;
        }
        return -1;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new EnergyWrapper(stack);
    }

    @Nonnull
    public Set<String> getToolClasses(ItemStack stack) {
        return toolClasses;
    }

    public boolean canHarvestBlock(@Nonnull IBlockState state, ItemStack stack) {
        return true;
    }
}

