/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.common.block.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileItemInterface
extends TileEntity
implements IItemHandler {
    private ItemStack storedItem = null;

    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        if (this.storedItem != null) {
            compound.func_74782_a("StoredItem", (NBTBase)this.storedItem.serializeNBT());
        }
        return super.func_189515_b(compound);
    }

    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        if (compound.func_74764_b("StoredItem")) {
            this.storedItem = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)compound.func_74781_a("StoredItem")));
        }
        super.func_145839_a(compound);
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.storedItem;
    }

    @Nullable
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.storedItem == null) {
            if (stack.field_77994_a == 1) {
                if (!simulate) {
                    this.storedItem = stack;
                    this.updateClient();
                    this.func_70296_d();
                }
                return null;
            }
            ItemStack storedCopy = stack.func_77946_l();
            storedCopy.field_77994_a = 1;
            ItemStack returnCopy = stack.func_77946_l();
            returnCopy.field_77994_a = stack.field_77994_a - 1;
            if (!simulate) {
                this.storedItem = storedCopy;
                this.updateClient();
                this.func_70296_d();
            }
            return returnCopy;
        }
        return stack;
    }

    @Nullable
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.storedItem == null) {
            return null;
        }
        ItemStack copy = this.storedItem.func_77946_l();
        copy.field_77994_a = Math.min(copy.field_77994_a, amount);
        if (!simulate) {
            this.storedItem.field_77994_a -= copy.field_77994_a;
            if (this.storedItem.field_77994_a == 0) {
                this.storedItem = null;
            }
            this.func_70296_d();
            this.updateClient();
        }
        return copy;
    }

    private void updateClient() {
        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
        this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if ((facing == EnumFacing.UP || facing == EnumFacing.DOWN) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return this.storedItem != null && this.storedItem.hasCapability(capability, facing) || super.hasCapability(capability, facing);
    }

    @Nonnull
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        Object t;
        if ((facing == EnumFacing.UP || facing == EnumFacing.DOWN) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        Object object = t = this.storedItem == null ? null : this.storedItem.getCapability(capability, facing);
        if (t == null) {
            return (T)super.getCapability(capability, facing);
        }
        return (T)t;
    }

    public ItemStack getStoredItem() {
        return this.storedItem;
    }

    public void breakBlock() {
        if (this.storedItem != null) {
            this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), this.storedItem));
        }
    }
}

