/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.resource;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.FallbackResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public enum CompressedResourcePack implements IResourcePack
{
    INSTANCE;

    private Map<ResourceLocation, BufferedImage> images = Maps.newHashMap();
    private Map<ResourceLocation, String> blockStates = Maps.newHashMap();
    private Set<String> domains = Sets.newHashSet();

    public void addImage(@Nonnull ResourceLocation res, @Nonnull BufferedImage image) {
        this.images.put(res, image);
    }

    public void addBlockState(ResourceLocation res, String state) {
        this.blockStates.put(res, state);
    }

    public void addDomain(String domain) {
        this.domains.add(domain);
    }

    public void inject() {
        List defaultResourcePacks = (List)ReflectionHelper.getPrivateValue(Minecraft.class, (Object)Minecraft.func_71410_x(), (String[])new String[]{"field_110449_ao", "defaultResourcePacks"});
        defaultResourcePacks.add(this);
        Map domainResourceManagers = (Map)ReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()), (String[])new String[]{"field_110548_a", "domainResourceManagers"});
        ((FallbackResourceManager)domainResourceManagers.get("overloaded")).func_110538_a((IResourcePack)this);
    }

    @Nonnull
    public InputStream func_110590_a(@Nonnull ResourceLocation location) throws IOException {
        if (location.func_110623_a().endsWith(".png")) {
            return this.getImageInputStream(location);
        }
        String state = this.blockStates.get(location);
        if (state != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            os.write(state.getBytes());
            return new ByteArrayInputStream(os.toByteArray());
        }
        throw new FileNotFoundException(location.toString());
    }

    private InputStream getImageInputStream(@Nonnull ResourceLocation location) throws IOException {
        BufferedImage image = this.images.get(location);
        if (image != null) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        throw new FileNotFoundException(location.toString());
    }

    public boolean func_110589_b(@Nonnull ResourceLocation location) {
        return this.images.containsKey(location) || this.blockStates.containsKey(location);
    }

    @Nonnull
    public Set<String> func_110587_b() {
        return ImmutableSet.copyOf(this.domains);
    }

    public <T extends IMetadataSection> T func_135058_a(@Nonnull MetadataSerializer metadataSerializer, @Nonnull String metadataSectionName) throws IOException {
        return null;
    }

    @Nonnull
    public BufferedImage func_110586_a() throws IOException {
        return null;
    }

    public String func_130077_b() {
        return "Overloaded Compressed Textures";
    }
}

