/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.render.block.compressed;

import com.cjm721.overloaded.common.block.compressed.BlockCompressed;
import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class CompressedBakedModel
implements IBakedModel {
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final VertexFormat format;
    private final Map<Block, List<BakedQuad>> cache;
    private final IBakedModel defaultModel;

    CompressedBakedModel(VertexFormat format, IBlockState state, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.format = format;
        this.defaultModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        this.cache = new HashMap<Block, List<BakedQuad>>();
        this.bakedTextureGetter = bakedTextureGetter;
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, float u, float v, TextureAtlasSprite sprite) {
        block6: for (int e = 0; e < this.format.func_177345_h(); ++e) {
            switch (this.format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.format.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private BakedQuad createQuad(Vec3d v1, Vec3d v2, Vec3d v3, Vec3d v4, TextureAtlasSprite sprite) {
        Vec3d normal = v3.func_178788_d(v2).func_72431_c(v1.func_178788_d(v2)).func_72432_b();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(sprite);
        this.putVertex(builder, normal, v1.field_72450_a, v1.field_72448_b, v1.field_72449_c, 0.0f, 0.0f, sprite);
        this.putVertex(builder, normal, v2.field_72450_a, v2.field_72448_b, v2.field_72449_c, 0.0f, 16.0f, sprite);
        this.putVertex(builder, normal, v3.field_72450_a, v3.field_72448_b, v3.field_72449_c, 16.0f, 16.0f, sprite);
        this.putVertex(builder, normal, v4.field_72450_a, v4.field_72448_b, v4.field_72449_c, 16.0f, 0.0f, sprite);
        return builder.build();
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        Block block = state == null ? Blocks.field_150347_e : state.func_177230_c();
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        BlockCompressed compressedBlock = (BlockCompressed)block;
        IBakedModel tempModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(compressedBlock.getBaseBlock().func_176223_P());
        if (side == null) {
            for (EnumFacing face : EnumFacing.values()) {
                this.getQuadsForSide(face, quads, compressedBlock, tempModel);
            }
        } else {
            this.getQuadsForSide(side, quads, compressedBlock, tempModel);
        }
        return quads;
    }

    private void getQuadsForSide(@Nonnull EnumFacing side, @Nonnull List<BakedQuad> quads, @Nonnull BlockCompressed compressedBlock, @Nonnull IBakedModel tempModel) {
        List baseQuads = tempModel.func_188616_a(compressedBlock.getBaseBlock().func_176223_P(), side, 0L);
        if (baseQuads.size() == 0) {
            return;
        }
        TextureAtlasSprite sprite = ((BakedQuad)baseQuads.get(0)).func_187508_a();
        switch (side) {
            case WEST: {
                quads.add(this.createQuad(new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 1.0, 1.0), sprite));
            }
            case EAST: {
                quads.add(this.createQuad(new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 1.0, 0.0), sprite));
            }
            case NORTH: {
                quads.add(this.createQuad(new Vec3d(1.0, 1.0, 0.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(0.0, 1.0, 0.0), sprite));
            }
            case SOUTH: {
                quads.add(this.createQuad(new Vec3d(0.0, 1.0, 1.0), new Vec3d(0.0, 0.0, 1.0), new Vec3d(1.0, 0.0, 1.0), new Vec3d(1.0, 1.0, 1.0), sprite));
            }
            case UP: {
                quads.add(this.createQuad(new Vec3d(0.0, 1.0, 0.0), new Vec3d(0.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 1.0), new Vec3d(1.0, 1.0, 0.0), sprite));
            }
            case DOWN: {
                quads.add(this.createQuad(new Vec3d(0.0, 0.0, 1.0), new Vec3d(0.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 0.0), new Vec3d(1.0, 0.0, 1.0), sprite));
            }
        }
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.defaultModel.func_188617_f();
    }

    public boolean func_177555_b() {
        return this.defaultModel.func_177555_b();
    }

    public boolean func_177556_c() {
        return this.defaultModel.func_177556_c();
    }

    public boolean func_188618_c() {
        return this.defaultModel.func_188618_c();
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.defaultModel.func_177554_e();
    }

    @Deprecated
    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return this.defaultModel.func_177552_f();
    }
}

