/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.tileentity;

import cofh.api.energy.IEnergyProvider;
import com.miningmark48.pearcelmod.handler.IGeneratorFuelHandler;
import com.miningmark48.pearcelmod.init.GeneratorRegistry;
import com.miningmark48.pearcelmod.init.ModBlocks;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class TileEntityPearcelGenerator
extends TileEntity
implements IInventory,
IEnergyStorage,
ITickable,
IEnergyProvider {
    private int increase_per_tick;
    private int maxRF = 250000;
    private int current_RF;
    private int cooldown;
    private int maxExtract = 10000;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private String customName;

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.customName) : new TextComponentString(ModBlocks.pearcel_generator.func_149732_F());
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.func_70302_i_()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.inventory.get(index);
    }

    @Nullable
    public ItemStack func_70298_a(int index, int count) {
        if (this.func_70301_a(index) != ItemStack.field_190927_a) {
            if (this.func_70301_a(index).func_190916_E() <= count) {
                ItemStack itemStack = this.func_70301_a(index);
                this.func_70299_a(index, ItemStack.field_190927_a);
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this.func_70301_a(index).func_77979_a(count);
            if (this.func_70301_a(index).func_190916_E() <= 0) {
                this.func_70299_a(index, ItemStack.field_190927_a);
            } else {
                this.func_70299_a(index, this.func_70301_a(index));
            }
            this.func_70296_d();
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int index, @Nullable ItemStack stack) {
        if (index < 0 || index >= this.func_70302_i_()) {
            return;
        }
        if (stack != ItemStack.field_190927_a && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (stack != ItemStack.field_190927_a && stack.func_190926_b()) {
            stack = ItemStack.field_190927_a;
        }
        this.inventory.set(index, (Object)stack);
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof IGeneratorFuelHandler;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.current_RF;
            }
            case 1: {
                return this.maxRF;
            }
            case 2: {
                return this.cooldown;
            }
            case 3: {
                return this.increase_per_tick;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.current_RF = value;
            }
            case 1: {
                break;
            }
            case 2: {
                this.cooldown = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == ItemStack.field_190927_a || this.func_70301_a(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        compound.func_74782_a("Items", (NBTBase)list);
        compound.func_74768_a("currentRF", this.current_RF);
        compound.func_74768_a("cooldown", this.cooldown);
        compound.func_74768_a("ipt", this.increase_per_tick);
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", this.getCustomName());
        }
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList list = compound.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            this.func_70299_a(slot, new ItemStack(stackTag));
        }
        this.current_RF = compound.func_74762_e("currentRF");
        this.cooldown = compound.func_74762_e("cooldown");
        this.increase_per_tick = compound.func_74762_e("ipt");
        if (compound.func_150297_b("CustomName", 8)) {
            this.setCustomName(compound.func_74779_i("CustomName"));
        }
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            if (this.canUse() && this.cooldown <= 0) {
                this.cooldown = TileEntityPearcelGenerator.getCooldownTime((ItemStack)this.inventory.get(0));
                this.increase_per_tick = TileEntityPearcelGenerator.getRFPerTick((ItemStack)this.inventory.get(0));
                ((ItemStack)this.inventory.get(0)).func_190918_g(1);
                if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
                    this.inventory.set(0, (Object)ItemStack.field_190927_a);
                }
            }
            if (this.cooldown > 0) {
                --this.cooldown;
                if (this.current_RF < this.maxRF) {
                    this.current_RF += this.func_174887_a_(3);
                }
            }
            if (this.getEnergyStored() > 0) {
                for (EnumFacing facing : EnumFacing.values()) {
                    TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                    if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())) continue;
                    ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.func_176734_d())).receiveEnergy(this.extractEnergy(this.maxExtract, false), false);
                }
            }
            this.func_70296_d();
        }
    }

    private boolean canUse() {
        if (this.inventory.get(0) != ItemStack.field_190927_a) {
            return ((ItemStack)this.inventory.get(0)).func_77973_b() instanceof IGeneratorFuelHandler && this.current_RF < this.maxRF;
        }
        return false;
    }

    public String func_70005_c_() {
        return this.customName;
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.equals("");
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189515_b(compound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, compound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public static int getCooldownTime(ItemStack stack) {
        return GeneratorRegistry.getCooldownTime(stack);
    }

    public static int getRFPerTick(ItemStack stack) {
        return GeneratorRegistry.getRFPerTick(stack);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.current_RF, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.current_RF -= energyExtracted;
        }
        return energyExtracted;
    }

    public int getEnergyStored() {
        if (this.current_RF >= this.getMaxEnergyStored()) {
            this.current_RF = this.getMaxEnergyStored();
        }
        return this.current_RF;
    }

    public int getMaxEnergyStored() {
        return this.maxRF;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = Math.min(this.current_RF, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.current_RF -= energyExtracted;
        }
        return energyExtracted;
    }
}

