/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.item;

import cofh.api.energy.ItemEnergyContainer;
import com.miningmark48.mininglib.utility.KeyChecker;
import com.miningmark48.mininglib.utility.ModTranslate;
import com.miningmark48.pearcelmod.entity.EntityEnderPearcel;
import com.miningmark48.pearcelmod.handler.ConfigurationHandler;
import com.miningmark48.pearcelmod.handler.IGeneratorFuelHandler;
import com.miningmark48.pearcelmod.init.ModItems;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemEnderPearcel
extends ItemEnergyContainer
implements IGeneratorFuelHandler {
    public ItemEnderPearcel() {
        super(ConfigurationHandler.rfStorage_enderPearcel, ConfigurationHandler.rfTransferPerTick_enderPearcel);
        this.func_77656_e(128);
        this.func_77625_d(1);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (KeyChecker.isHoldingShift()) {
            list.add(ModTranslate.toLocal((String)"tooltip.item.pearcelPearl.line1"));
            if (ConfigurationHandler.rfUseEnabled_enderPearcel) {
                list.add(TextFormatting.GREEN + ModTranslate.toLocal((String)"tooltip.item.rfUse") + " " + ConfigurationHandler.rfPerUse_enderPearcel + " RF/Use");
            }
            if (ConfigurationHandler.rfUseEnabled_enderPearcel) {
                list.add(TextFormatting.RED + ModTranslate.toLocal((String)"tooltip.item.rf") + " " + TextFormatting.GREEN + this.getEnergyStored(stack) + " / " + this.getMaxEnergyStored(stack));
            }
        } else {
            list.add(ModTranslate.toLocal((String)"tooltip.item.hold") + " " + TextFormatting.AQUA + TextFormatting.ITALIC + ModTranslate.toLocal((String)"tooltip.item.shift"));
        }
    }

    public ActionResult func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        float velocity = ConfigurationHandler.enderPearcelVelocity;
        if (!player.func_184812_l_()) {
            if (ItemEnderPearcel.hasEnoughEnergy(stack, ConfigurationHandler.rfPerUse_enderPearcel, player)) {
                ItemEnderPearcel.useEnergy(stack, ConfigurationHandler.rfPerUse_enderPearcel, false, player);
            } else {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        if (ConfigurationHandler.doEnderPearcelCooldown) {
            player.func_184811_cZ().func_185145_a((Item)this, ConfigurationHandler.enderPearcelCooldownTime * 20);
        }
        world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 0.5f, 0.4f);
        if (!world.field_72995_K) {
            EntityEnderPearcel pearl = new EntityEnderPearcel(world, (EntityLivingBase)player);
            pearl.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, velocity, 0.0f);
            world.func_72838_d((Entity)pearl);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private static boolean hasEnoughEnergy(ItemStack stack, int energyPerUse, EntityPlayer player) {
        ItemEnderPearcel stack1;
        if (!ConfigurationHandler.rfUseEnabled_enderPearcel) {
            return true;
        }
        return !player.func_184812_l_() && energyPerUse <= (stack1 = new ItemEnderPearcel()).getEnergyStored(stack);
    }

    public static void useEnergy(ItemStack stack, int useAmount, boolean simulate, EntityPlayer player) {
        if (!player.func_184812_l_() && ConfigurationHandler.rfUseEnabled_enderPearcel) {
            ItemEnderPearcel stack1 = new ItemEnderPearcel();
            stack1.extractEnergy(stack, useAmount, simulate);
        }
    }

    @Override
    public int getCooldownTime(ItemStack fuel) {
        if (fuel.func_77969_a(new ItemStack(ModItems.ender_pearcel))) {
            return 500;
        }
        return 0;
    }

    @Override
    public int getRFPerTick(ItemStack fuel) {
        if (fuel.func_77969_a(new ItemStack(ModItems.ender_pearcel))) {
            return 25;
        }
        return 0;
    }
}

