/*
 * Decompiled with CFR 0.152.
 */
package com.miningmark48.pearcelmod.init;

import com.google.common.collect.Lists;
import com.miningmark48.mininglib.utility.ModLogger;
import com.miningmark48.pearcelmod.handler.IGeneratorFuelHandler;
import com.miningmark48.pearcelmod.init.ModItems;
import com.miningmark48.pearcelmod.item.ItemCharmedPearcel;
import com.miningmark48.pearcelmod.item.ItemEnderPearcel;
import com.miningmark48.pearcelmod.item.ItemPearcelFood;
import com.miningmark48.pearcelmod.item.ItemPearcelFuel;
import com.miningmark48.pearcelmod.item.ItemPearcelMod;
import com.miningmark48.pearcelmod.item.ItemPearcelModEffect;
import java.util.List;
import net.minecraft.item.ItemStack;

public class GeneratorRegistry {
    private static List<IGeneratorFuelHandler> fuelHandlers = Lists.newArrayList();
    private static List<ItemStack> fuels = Lists.newArrayList();

    public static void registerGeneratorFuels() {
        fuelHandlers.clear();
        GeneratorRegistry.registerGeneratorFuel(new ItemPearcelFood(0, 0.0f, false));
        GeneratorRegistry.registerGeneratorFuel(new ItemPearcelFuel());
        GeneratorRegistry.registerGeneratorFuel(new ItemPearcelModEffect());
        GeneratorRegistry.registerGeneratorFuel(new ItemPearcelMod());
        GeneratorRegistry.registerGeneratorFuel(new ItemCharmedPearcel());
        GeneratorRegistry.registerGeneratorFuel(new ItemEnderPearcel());
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_item));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_bread));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_charcoal));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_matter));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_sandwich));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_star));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.tier_4_crafting_component));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.tier_3_crafting_component));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.tier_2_crafting_component));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.tier_1_crafting_component));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_cookie));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_pie));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.golden_pearcel));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.jeweled_pearcel));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.glowing_pearcel));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_juice_bottle));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.charmed_pearcel));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.ender_pearcel));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.blood_drop));
        GeneratorRegistry.addFuelToList(new ItemStack(ModItems.pearcel_ingot));
        ModLogger.info((Object)"Registered Generator Fuels");
    }

    public static void registerGeneratorFuel(IGeneratorFuelHandler handler) {
        fuelHandlers.add(handler);
    }

    public static int getCooldownTime(ItemStack itemStack) {
        int cooldown = 0;
        for (IGeneratorFuelHandler handler : fuelHandlers) {
            cooldown = Math.max(cooldown, handler.getCooldownTime(itemStack));
        }
        return cooldown;
    }

    public static int getRFPerTick(ItemStack itemStack) {
        int rfPerTick = 0;
        for (IGeneratorFuelHandler handler : fuelHandlers) {
            rfPerTick = Math.max(rfPerTick, handler.getRFPerTick(itemStack));
        }
        return rfPerTick;
    }

    public static void addFuelToList(ItemStack itemStack) {
        fuels.add(itemStack);
    }

    public static List<ItemStack> getFuels() {
        return fuels;
    }
}

